% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qte.R
\name{ci.qte}
\alias{ci.qte}
\title{ci.qte}
\usage{
ci.qte(formla, x = NULL, data, probs = seq(0.05, 0.95, 0.05), se = TRUE,
  iters = 100, alp = 0.05, plot = FALSE, method = "logit",
  seedvec = NULL, indsample = TRUE, printIter = FALSE)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{x}{Vector of covariates.  Default is no covariates}

\item{data}{The name of the data.frame that contains the data}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{se}{Boolean whether or not to compute standard errors}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{plot}{Boolean whether or not the estimated QTET should be plotted}

\item{method}{Method to compute propensity score.  Default is logit; other
option is probit.}

\item{seedvec}{Optional value to set random seed; can possibly be used
 in conjunction with bootstrapping standard errors.}

\item{indsample}{Binary variable for whether to treat the samples as
independent or dependent.  This affects bootstrap standard errors.  In
the job training example, the samples are independent because they
are two samples collected independently and then merged.  If the data is
from the same source, usually should set this option to be FALSE.}

\item{printIter}{For debugging only; should leave at default FALSE unless
 you want to see a lot of output}
}
\value{
QTE object
}
\description{
The \code{ci.qtet} method implements estimates the Quantile
Treatment Effect (QTE) under a Conditional Independence
Assumption (sometimes this is called Selection on Observables) developed
in Firpo (2007).  This method using propensity score re-weighting
and minimizes a check function to compute the QTET.  Standard errors
(if requested) are computed using the bootstrap.
}
\examples{
## Load the data
data(lalonde)

##Estimate the QTET of participating in the job training program;
##This is the no covariate case.  Note: Because individuals that participate
## in the job training program are likely to be much different than
## individuals that do not (e.g. less experience and less education), this
## method is likely to perform poorly at estimating the true QTET
q1 <- ci.qte(re78 ~ treat, x=NULL, data=lalonde.psid, se=FALSE,
 probs=seq(0.05,0.95,0.05))
summary(q1)

##This estimation controls for all the available background characteristics.
q2 <- ci.qte(re78 ~ treat,
 x=c("age","education","black","hispanic","married","nodegree"),
 data=lalonde.psid, se=FALSE, probs=seq(0.05, 0.95, 0.05))
summary(q2)
}
\references{
Firpo, Sergio.   ``Efficient Semiparametric Estimation of Quantile Treatment
 Effects.'' Econometrica 75.1, pp. 259-276, 2015.
}

