% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_snps.R
\name{recode_snps}
\alias{recode_snps}
\title{Recode SNPs by major allele}
\usage{
recode_snps(cross)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}
}
\value{
The input cross object with the raw SNP genotypes recoded so that
\code{1} is homozygous for the major alleles in the founders.
}
\description{
For multi-parent populations with founder genotypes, recode the raw
SNP genotypes so that \code{1} means homozygous for the major allele in the
founders.
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/master/DOex/DOex.zip")
DOex <- read_cross2(file)
DOex <- recode_snps(DOex)
}
}
\seealso{
\code{\link[=calc_raw_founder_maf]{calc_raw_founder_maf()}}, \code{\link[=calc_raw_maf]{calc_raw_maf()}}
}
\keyword{utilities}
