% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind_viterbi.R
\name{rbind.viterbi}
\alias{rbind.viterbi}
\title{Join Viterbi results for different individuals}
\usage{
\method{rbind}{viterbi}(...)
}
\arguments{
\item{...}{Imputed genotype objects as produced by
\code{\link[=viterbi]{viterbi()}}. Must have the same set of markers.}
}
\value{
An object of class \code{"viterbi"}, like the input; see \code{\link[=viterbi]{viterbi()}}.
}
\description{
Join multiple imputed genotype objects, as produced by \code{\link[=viterbi]{viterbi()}},
for the same set of markers but for different individuals.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
gA <- viterbi(grav2[1:5,], map, error_prob=0.002)
gB <- viterbi(grav2[6:12,], map, error_prob=0.002)
g <- rbind(gA, gB)

}
\seealso{
\code{\link[=cbind.viterbi]{cbind.viterbi()}}, \code{\link[=viterbi]{viterbi()}}
}
