% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi.R
\name{viterbi}
\alias{viterbi}
\title{Calculate most probable sequence of genotypes}
\usage{
viterbi(
  cross,
  map = NULL,
  error_prob = 0.0001,
  map_function = c("haldane", "kosambi", "c-f", "morgan"),
  lowmem = FALSE,
  quiet = TRUE,
  cores = 1
)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{map}{Genetic map of markers. May include pseudomarker
locations (that is, locations that are not within the marker
genotype data). If NULL, the genetic map in \code{cross} is used.}

\item{error_prob}{Assumed genotyping error probability}

\item{map_function}{Character string indicating the map function to
use to convert genetic distances to recombination fractions.}

\item{lowmem}{If \code{FALSE}, split individuals into groups with
common sex and crossinfo and then precalculate the transition
matrices for a chromosome; potentially a lot faster but using more
memory.}

\item{quiet}{If \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
An object of class \code{"viterbi"}: a list of two-dimensional
arrays of imputed genotypes, individuals x positions.
Also contains three attributes:
\itemize{
\item \code{crosstype} - The cross type of the input \code{cross}.
\item \code{is_x_chr} - Logical vector indicating whether chromosomes
are to be treated as the X chromosome or not, from input \code{cross}.
\item \code{alleles} - Vector of allele codes, from input
\code{cross}.
}
}
\description{
Uses a hidden Markov model to calculate arg max Pr(g | O) where g
is the underlying sequence of true genotypes and O is the observed
multipoint marker data, with possible allowance for genotyping
errors.
}
\details{
We use a hidden Markov model to find, for each individual
on each chromosome, the most probable sequence of underlying
genotypes given the observed marker data.

Note that we break ties at random, and our method for doing this
may introduce some bias.

Consider the results with caution; the most probable sequence can
have very low probability, and can have features that are quite
unusual (for example, the number of recombination events can be too
small). In most cases, the results of a single imputation with
\code{\link[=sim_geno]{sim_geno()}} will be more realistic.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map_w_pmar <- insert_pseudomarkers(grav2$gmap, step=1)
g <- viterbi(grav2, map_w_pmar, error_prob=0.002)
}
\seealso{
\code{\link[=sim_geno]{sim_geno()}}, \code{\link[=maxmarg]{maxmarg()}}, \code{\link[=cbind.viterbi]{cbind.viterbi()}}, \code{\link[=rbind.viterbi]{rbind.viterbi()}}
}
