% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scan1.R
\name{plot_scan1}
\alias{plot_scan1}
\alias{plot.scan1}
\title{Plot a genome scan}
\usage{
plot_scan1(x, map, lodcolumn = 1, chr = NULL, add = FALSE, gap = NULL, ...)

\method{plot}{scan1}(x, map, lodcolumn = 1, chr = NULL, add = FALSE, gap = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{"scan1"}, as output by \code{\link[=scan1]{scan1()}}.}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[=insert_pseudomarkers]{insert_pseudomarkers()}}.}

\item{lodcolumn}{LOD score column to plot (a numeric index, or a
character string for a column name). Only one value allowed.}

\item{chr}{Selected chromosomes to plot; a vector of character
strings.}

\item{add}{If TRUE, add to current plot (must have same map and
chromosomes).}

\item{gap}{Gap between chromosomes. The default is 1\% of the total genome length.}

\item{...}{Additional graphics parameters.}
}
\value{
None.
}
\description{
Plot LOD curves for a genome scan
}
\section{Hidden graphics parameters}{

A number of graphics parameters can be passed via \code{...}. For
example, \code{bgcolor} to control the background color and
\code{altbgcolor} to control the background color on alternate chromosomes.
\code{col} controls the color of lines/curves; \code{altcol} can be used if
you want alternative chromosomes in different colors.
These are not included as formal parameters in order to avoid
cluttering the function definition.
}

\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# perform genome scan
out <- scan1(probs, pheno, addcovar=covar, Xcovar=Xcovar)

# plot the results for selected chromosomes
ylim <- c(0, maxlod(out)*1.02) # need to strip class to get overall max LOD
chr <- c(2,7,8,9,15,16)
plot(out, map, chr=chr, ylim=ylim)
plot(out, map, lodcolumn=2, chr=chr, col="violetred", add=TRUE)
legend("topleft", lwd=2, col=c("darkslateblue", "violetred"), colnames(out),
       bg="gray90")

# plot just one chromosome
plot(out, map, chr=8, ylim=ylim)
plot(out, map, chr=8, lodcolumn=2, col="violetred", add=TRUE)

# lodcolumn can also be a column name
plot(out, map, lodcolumn="liver", ylim=ylim)
plot(out, map, lodcolumn="spleen", col="violetred", add=TRUE)
}
\seealso{
\code{\link[=plot_coef]{plot_coef()}}, \code{\link[=plot_coefCC]{plot_coefCC()}}, \code{\link[=plot_snpasso]{plot_snpasso()}}
}
