% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genoprob_to_alleleprob.R
\name{genoprob_to_alleleprob}
\alias{genoprob_to_alleleprob}
\title{Convert genotype probabilities to allele probabilities}
\usage{
genoprob_to_alleleprob(probs, quiet = TRUE, cores = 1)
}
\arguments{
\item{probs}{Genotype probabilities, as calculated from
\code{\link[=calc_genoprob]{calc_genoprob()}}.}

\item{quiet}{IF \code{FALSE}, print progress messages.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input \code{probs},
but with probabilities collapsed to alleles rather than genotypes. See \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Reduce genotype probabilities (as calculated by
\code{\link[=calc_genoprob]{calc_genoprob()}}) to allele probabilities.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
gmap_w_pmar <- insert_pseudomarkers(iron, step=1)
probs <- calc_genoprob(iron, gmap_w_pmar, error_prob=0.002)
allele_probs <- genoprob_to_alleleprob(probs)
}
\keyword{utilities}
