% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_extract.R
\name{fst_extract}
\alias{fst_extract}
\alias{fst2calc_genoprob}
\title{Extract genotype probabilities from fst database}
\usage{
fst_extract(object)

fst2calc_genoprob(object)
}
\arguments{
\item{object}{Object of class \code{"fst_genoprob"}, linking to an fst database of genotype probabilities.}
}
\value{
An object of class \code{"calc_genoprob"} (a list of 3-dimensional arrays).
}
\description{
Extract genotype probabilities from fst database as an ordinary calc_genoprob object.
}
\details{
The genotype probabilities are extracted from the fst database. Each chromosome is extracted in turn.
}
\section{Functions}{
\itemize{
\item \code{fst2calc_genoprob}: Deprecated version (to be deleted)
}}

\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probs <- calc_genoprob(grav2, map, error_prob=0.002)
dir <- tempdir()
fprobs <- fst_genoprob(probs, "grav2", dir, overwrite=TRUE)
nprobs <- fst_extract(fprobs)

# clean up: remove all the files we created
unlink(fst_files(fprobs))
}
\seealso{
\code{\link[=fst_genoprob]{fst_genoprob()}}
}
\keyword{utilities}
