% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estQTLeffects.R
\name{estQTLeffects}
\alias{estQTLeffects}
\title{Calculate QTL effects at each position across the genome}
\usage{
estQTLeffects(cross, pheno.col = 1, what = c("means", "effects"))
}
\arguments{
\item{cross}{(Optional) Object of class \code{"cross"}, see
\code{\link[qtl]{read.cross}}.}

\item{pheno.col}{Phenotype columns in cross object.}

\item{what}{Indicates whether to calculate phenotype averages for
each genotype group or to turn these into additive and dominance
effects.}
}
\value{
list of matrices; each component corresponds to a position
in the genome and is a matrix with phenotypes x effects
}
\description{
Calculates the effects of QTL at each position across the genome
using Haley-Knott regression, much like \code{\link[qtl]{effectscan}},
but considering multiple phenotypes and not plotting the results
}
\details{
One should first run \code{\link[qtl]{calc.genoprob}};
if not, it is run with the default arguments.

The estimated effects will be poorly estimated in the case of
selective genotyping, as Haley-Knott regression performs poorly in
this case.
}
\examples{
data(grav)
library(qtl)
grav <- reduce2grid(calc.genoprob(grav, step=1))
out <- estQTLeffects(grav, phe=seq(1, nphe(grav), by=5))

}
\seealso{
\code{\link{iplotMScanone}}, \code{\link[qtl]{effectscan}}
\code{\link{cbindQTLeffects}}
}
\keyword{regression}
