% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clean.R
\name{wordstem}
\alias{wordstem}
\title{stem words}
\usage{
wordstem(words, language = "porter")
}
\arguments{
\item{words}{a character vector of words whose stems are to be extracted.}

\item{language}{the name of a recognized language, as returned by
\link[SnowballC]{getStemLanguages}, or a two- or three-letter ISO-639 code
corresponding to one of these languages (see references for the list of
codes)}
}
\value{
A character vector with as many elements as there are in the input
  vector with the corresponding elements being the stem of the word. Elements
  of the vector are converted to UTF-8 encoding before the stemming is
  performed, and the returned elements are marked as such when they contain
  non-ASCII characters.
}
\description{
Apply a stemmer to words.  This is a wrapper to \link[SnowballC]{wordStem}
designed to allow this function to be called without loading the entire
\pkg{SnowballC} package.  \link[SnowballC]{wordStem}  uses Martin Porter's
stemming algorithm and the C libstemmer library generated by Snowball.
}
\examples{
# Simple example
wordstem(c("win", "winning", "winner"))
}
\references{
\url{http://snowball.tartarus.org/}

  \url{http://www.iso.org/iso/home/standards/language_codes.htm} for the
  ISO-639 language codes
}
\seealso{
\link[SnowballC]{wordStem}
}

