% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-weighting.R
\docType{methods}
\name{weight}
\alias{smoother}
\alias{weight}
\alias{weight,dfm-method}
\alias{weighting}
\alias{weighting,dfm-method}
\title{weight the feature frequencies in a dfm by various methods}
\usage{
weight(x, ...)

\S4method{weight}{dfm}(x, type = c("frequency", "relFreq", "relMaxFreq",
  "logFreq", "tfidf"), ...)

smoother(x, smoothing)

weighting(object)

\S4method{weighting}{dfm}(object)
}
\arguments{
\item{x}{document-feature matrix created by \link{dfm}}

\item{...}{not currently used}

\item{type}{The weighting function to aapply to the dfm. One of: \itemize{ 
\item normTf - Length normalization: dividing the frequency of the feature 
by the length of the document) \item logTf - The natural log of the term
frequency \item tf-idf - Term-frequency * inverse document frequency. For a
full explanation, see, for example, 
\url{http://nlp.stanford.edu/IR-book/html/htmledition/term-frequency-and-weighting-1.html}.
 This implementation will not return negative values.  For finer-grained
control, call \code{\link{tfidf}} directly. \item maxTf - The term
frequency divided by the frequency of the most frequent term in the
document \item ppmi -   Positive Pointwise Mutual Information }}

\item{smoothing}{constant added to the dfm cells for smoothing}

\item{object}{the dfm object for accessing the weighting setting}
}
\value{
The dfm with weighted values

\code{weighting} returns a character object describing the type of weighting applied to the dfm.
}
\description{
Returns a document by feature matrix with the feature frequencies weighted 
according to one of several common methods.
}
\details{
\code{smoother(x, smoothing)} is a shortcut for \code{weight(x, "frequency", smoothing)}

\code{weighting} queries (but cannot set) the weighting applied to the dfm.
}
\examples{
dtm <- dfm(inaugCorpus)
x <- apply(dtm, 1, function(tf) tf/max(tf))
topfeatures(dtm)
normDtm <- weight(dtm, "relFreq")
topfeatures(normDtm)
maxTfDtm <- weight(dtm, type="relMaxFreq")
topfeatures(maxTfDtm)
logTfDtm <- weight(dtm, type="logFreq")
topfeatures(logTfDtm)
tfidfDtm <- weight(dtm, type="tfidf")
topfeatures(tfidfDtm)

# combine these methods for more complex weightings, e.g. as in Section 6.4 of
# Introduction to Information Retrieval
head(logTfDtm <- weight(dtm, type="logFreq"))
head(tfidf(logTfDtm, normalize = FALSE))

\dontshow{
testdfm <- dfm(inaugTexts[1:5], verbose = FALSE)
for (w in c("frequency", "relFreq", "relMaxFreq", "logFreq", "tfidf")) {
    testw <- weight(testdfm, w)
    cat("\\n\\n=== weight() TEST for:", w, "; class:", class(testw), "\\n")
    head(testw)
}
}
}
\author{
Paul Nulty and Kenneth Benoit
}
\references{
Manning, Christopher D., Prabhakar Raghavan, and Hinrich Schutze.
  Introduction to information retrieval. Vol. 1. Cambridge: Cambridge 
  university press, 2008.
}
\seealso{
\code{\link{tfidf}}
}

