% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R, R/dfm-methods.R
\name{docnames}
\alias{docnames}
\alias{docnames.corpus}
\alias{docnames.dfm}
\alias{docnames<-}
\title{get or set document names}
\usage{
docnames(x)

\method{docnames}{corpus}(x)

docnames(x) <- value

\method{docnames}{dfm}(x)
}
\arguments{
\item{x}{the object with docnames}

\item{value}{a character vector of the same length as \code{x}}
}
\value{
\code{docnames} returns a character vector of the document names

\code{docnames <-} assigns new values to the document names of a corpus. (Does not work
for dfm objects, whose document names are fixed.)
}
\description{
Get or set the document names from a corpus or a document-feature matrix.
of the \link{dfm} object.
}
\examples{
# query the document names of the inaugural speech corpus
docnames(inaugCorpus) <- paste("Speech", 1:ndoc(inaugCorpus), sep="")

# reassign the document names of the inaugural speech corpus
docnames(inaugCorpus) <- paste("Speech", 1:ndoc(inaugCorpus), sep="")

# query the document names of a dfm
docnames(dfm(inaugTexts[1:5]))
}

