% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\docType{methods}
\name{similarity}
\alias{similarity}
\alias{similarity,dfm-method}
\alias{as.matrix.similMatrix}
\title{compute similarities between documents and/or features}
\usage{
similarity(x, selection = NULL, n = NULL, margin = c("documents",
  "features"), method = "correlation", sorted = TRUE, normalize = FALSE)

\S4method{similarity}{dfm}(x, selection = NULL, n = NULL,
  margin = c("documents", "features"), method = "correlation",
  sorted = TRUE, normalize = FALSE)

\method{as.matrix}{similMatrix}(x, ...)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{selection}{character or character vector of document names or feature 
labels from the dfm}

\item{n}{the top \code{n} most similar items will be returned, sorted in 
descending order.  If n is \code{NULL}, return all items.}

\item{margin}{identifies the margin of the dfm on which similarity will be 
computed:  \code{documents} for documents or \code{features} for word/term
features.}

\item{method}{a valid method for computing similarity from 
\code{\link[proxy]{pr_DB}}}

\item{sorted}{sort results in descending order if \code{TRUE}}

\item{normalize}{a deprecated argument retained (temporarily) for legacy 
reasons.  If you want to compute similarity on a "normalized" dfm objects 
(e.g. \code{x}), wrap it in \code{\link{weight}(x, "relFreq")}.}

\item{...}{unused}
}
\value{
a named list of the selection labels, with a sorted named vector of 
  similarity measures.
}
\description{
Compute similarities between documents and/or features from a 
\code{\link{dfm}}. Uses the similarity measures defined in 
\link[proxy]{simil}.  See \code{\link[proxy]{pr_DB}} for available distance 
measures, or how to create your own.
}
\note{
The method for computing feature similarities can be quite slow when 
  there are large numbers of feature types.  Future implementations will 
  hopefully speed this up.
}
\examples{
# create a dfm from inaugural addresses from Reagan onwards
presDfm <- dfm(corpus_subset(data_corpus_inaugural, Year > 1980), stem = TRUE,
               remove = stopwords("english"))

# compute some document similarities
(tmp <- similarity(presDfm, margin = "documents"))
# output as a matrix
as.matrix(tmp)
# for specific comparisons
similarity(presDfm, "1985-Reagan", n = 5, margin = "documents")
similarity(presDfm, c("2009-Obama" , "2013-Obama"), n = 5, margin = "documents")
similarity(presDfm, c("2009-Obama" , "2013-Obama"), margin = "documents")
similarity(presDfm, c("2009-Obama" , "2013-Obama"), margin = "documents", method = "cosine")
similarity(presDfm, "2005-Bush", margin = "documents", method = "eJaccard", sorted = FALSE)

# compute some term similarities
similarity(presDfm, c("fair", "health", "terror"), method="cosine", margin = "features", 20)
}
\keyword{deprecated}
\keyword{internal}
