% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpuszip.R
\name{corpuszip}
\alias{corpuszip}
\title{construct a compressed corpus object}
\usage{
corpuszip(x, docnames = NULL, docvars = NULL, text_field = "text",
  metacorpus = NULL, ...)
}
\arguments{
\item{x}{a valid corpus source object}

\item{docnames}{Names to be assigned to the texts, defaults to the names of 
the character vector (if any), otherwise assigns "text1", "text2", etc.}

\item{docvars}{A data frame of attributes that is associated with each text.}

\item{text_field}{the character name or numeric index of the source \code{data.frame}
indicating the variable to be read in as text, which must be a character vector.
All other variables in the data.frame will be imported as docvars.  This argument 
is only used for \code{data.frame} objects (including those created by \pkg{readtext}).}

\item{metacorpus}{a named list containing additional (character) information to be added to the
corpus as corpus-level metadata.  Special fields recognized in the \code{\link{summary.corpus}}
are: 
\itemize{
\item{\code{source }}{a description of the source of the texts, used for 
  referencing;}
\item{\code{citation }}{information on how to cite the corpus; and}
\item{\code{notes }}{any additional information about who created the text, warnings, 
  to do lists, etc.}
}}

\item{...}{not used directly}
}
\description{
Construct a compressed version of a \link{corpus}.
}
\examples{
# create a compressed corpus from texts
corpuszip(data_char_inaugural)

# create a compressed corpus from texts and assign meta-data and document variables
cop <- corpus(data_char_ukimmig2010, 
              docvars = data.frame(party = names(data_char_ukimmig2010)))
cop_zip <- corpuszip(data_char_ukimmig2010, 
                     docvars = data.frame(party = names(data_char_ukimmig2010)))
object.size(cop)
object.size(cop_zip)

}
\keyword{corpuszip}
\keyword{internal}

