% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatures-old.R
\name{selectFeaturesOLD}
\alias{selectFeaturesOLD}
\alias{selectFeaturesOLD.tokenizedTexts}
\title{old version of selectFeatures.tokenizedTexts}
\usage{
selectFeaturesOLD(x, ...)

\method{selectFeaturesOLD}{tokenizedTexts}(x, features, selection = c("keep",
  "remove"), valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{x}{object whose features will be selected}

\item{...}{supplementary arguments passed to the underlying functions in 
\code{\link[stringi]{stri_detect_regex}}.  (This is how 
\code{case_insensitive} is passed, but you may wish to pass others.)}

\item{features}{one of: a character vector of features to be selected, a 
\link{dfm} whose features will be used for selection, or a dictionary class
object whose values (not keys) will provide the features to be selected. 
For \link{dfm} objects, see details in the Value section below.}

\item{selection}{whether to keep or remove the features}

\item{valuetype}{the type of pattern matching: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{ignore the case of dictionary values if \code{TRUE}}

\item{verbose}{if \code{TRUE} print message about how many features were 
removed}
}
\description{
Calls C++ for super-fast selection or removal of features from a 
set of tokens.
}
\examples{
toks <- tokenize(c("This is some example text from me.", "More of the example text."), 
                 remove_punct = TRUE)
selectFeaturesOLD(toks, stopwords("english"), "remove")
selectFeaturesOLD(toks, "ex", "keep", valuetype = "regex")
}
\keyword{deprecated}
\keyword{internal}
