% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern2fixed.R
\name{pattern2id}
\alias{pattern2id}
\alias{pattern2fixed}
\alias{index_types}
\title{Convert regex and glob patterns to type IDs or fixed patterns}
\usage{
pattern2id(
  pattern,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  keep_nomatch = FALSE
)

pattern2fixed(
  pattern,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  keep_nomatch = FALSE
)

index_types(types, valuetype, case_insensitive, max_len = NULL)
}
\arguments{
\item{pattern}{a character vector, list of character vectors,
\link{dictionary}, or \link{collocations} object.  See \link{pattern} for
details.}

\item{types}{unique types of tokens obtained by \code{\link{types}}}

\item{valuetype}{the type of pattern matching: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{if \code{TRUE}, ignores case when matching}

\item{keep_nomatch}{keep patterns not found}

\item{max_len}{maximum length of types to be indexed}
}
\value{
\code{pattern2id} returns a list of integer vectors containing type
  IDs

\code{pattern2fixed} returns a list of character vectors containing
  types

\code{index_types} returns a list of integer vectors containing type
  IDs with index keys as an attribute
}
\description{
\code{pattern2id} converts regex or glob to type IDs to allow
  C++ function to perform fast searches in tokens object. C++ functions use a
  list of type IDs to construct a hash table, against which sub-vectors of
  tokens object are matched. This function constructs an index of glob
  patterns for faster matching.

\code{pattern2fixed} converts regex and glob patterns to fixed patterns.

\code{index_types} is an auxiliary function for \code{pattern2id} that
constructs an index of "glob" or "fixed" patterns to avoid expensive
sequential search. For example, a type "cars" is index by keys "cars",
"car?", "c*", "ca*", "car*" and "cars*" when \code{valuetype="glob"}.
}
\examples{
types <- c("A", "AA", "B", "BB", "BBB", "C", "CC")

pats_regex <- list(c("^a$", "^b"), c("c"), c("d"))
pattern2id(pats_regex, types, "regex", case_insensitive = TRUE)

pats_glob <- list(c("a*", "b*"), c("c"), c("d"))
pattern2id(pats_glob, types, "glob", case_insensitive = TRUE)

pattern <- list(c("^a$", "^b"), c("c"), c("d"))
types <- c("A", "AA", "B", "BB", "BBB", "C", "CC")
pattern2fixed(pattern, types, "regex", case_insensitive = TRUE)
index <- index_types(c("xxx", "yyyy", "ZZZ"), "glob", FALSE, 3)
quanteda:::search_glob("yy*", attr(index, "type_search"), index)
}
\keyword{internal}
