% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs.R
\name{hs}
\alias{hs}
\title{Nonparametric calculation of univariate Value at Risk and Expected Shortfall}
\usage{
hs(x, p = 0.95, method = c("age", "plain"), lambda = 0.98)
}
\arguments{
\item{x}{a numeric vector of asset returns}

\item{p}{confidence level for VaR calculation; default is 0.95\%}

\item{method}{method to be used for calculation; default is 'plain'}

\item{lambda}{decay factor for the calculation of weights; default is 0.98}
}
\value{
Returns a list with the following elements:
\describe{
\item{VaR}{Calculated Value at Risk}
\item{ES}{Calculated Expected Shortfall}
}
}
\description{
Computes Value at Risk and Expected Shortfall by means of plain and age-
weighted historical simulation
}
\examples{
prices <- DAX30$price.close
returns <- diff(log(prices))
hs(x = returns, p = 0.95, method = 'plain')
hs(x = returns, p = 0.95, method = 'age', lambda = 0.98)
}
