% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_threshold.R
\name{calculate_threshold}
\alias{calculate_threshold}
\title{Calculate a Threshold for Rate Determination}
\usage{
calculate_threshold(
  data,
  background_cycle = 2,
  method = list("stdev", "none"),
  multiplier = 1
)
}
\arguments{
\item{data}{A dataframe output from get_real.}

\item{background_cycle}{Integer; the cycle used for background fluorescence.}

\item{method}{Method for determining threshold; default is "stdev".}

\item{multiplier}{For some methods, will add a multiplier for more conservative thresholds.}
}
\value{
A float value.
}
\description{
Calculates a threshold for determining time-to-threshold and rate of amyloid formation.
}
\examples{
file <- system.file(
  "extdata/input_files",
  file = "test2.xlsx",
  package = "quicR"
)
threshold <- get_real(file)[[1]] |>
  calculate_threshold(multiplier = 10)

}
