% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll.R
\name{nll}
\alias{nll}
\title{Negative Log Likelihood}
\usage{
nll(
  par,
  nit,
  K,
  l_s_c = NULL,
  g_s_c = NULL,
  g_t_c = NULL,
  o_s_c = NULL,
  o_t_c = NULL,
  p_s_c = NULL,
  p_t_c = NULL,
  SMALL_a_CORRECTION = FALSE,
  VERBOSE = FALSE,
  outfile = NULL
)
}
\arguments{
\item{par}{Vector of parameter values: c(log(lambda), log(gamma), logit(omega), logit(pdet)). Note that the parameter vector will need to be longer if covariate values are supplied.}

\item{nit}{Matrix of counts data. Rows represent sites, columns represent sampling occasions. Note that if the data is a vector, then it will be converted to a matrix with a single row.}

\item{K}{Upper bound on summations in the likelihood function. K should be chosen large enough that the negative log likelihood function is stable (unchanging as K increases).}

\item{l_s_c}{List of lambda site covariates, Default: NULL}

\item{g_s_c}{List of gamma site covariates, Default: NULL}

\item{g_t_c}{List of gamma time covariates, Default: NULL}

\item{o_s_c}{List of omega site covariates, Default: NULL}

\item{o_t_c}{List of omega time covariates, Default: NULL}

\item{p_s_c}{List of pdet site covariates, Default: NULL}

\item{p_t_c}{List of pdet time covariates, Default: NULL}

\item{SMALL_a_CORRECTION}{If TRUE will apply the small a correction when calculating the transition probability matrix, Default: FALSE}

\item{VERBOSE}{If TRUE, will print additional information, Default: FALSE}

\item{outfile}{Location of csv file to write/append parameter values, Default: NULL}
}
\value{
Returns the negative log likelihood function evaluated at par.
}
\description{
Computes the negative log likelihood function for the open population asymptotic N-mixtures model.
}
\details{
DETAILS
}
\examples{
nit = matrix(c(1,1,0,1,1), nrow=1) # observations for 1 site, 5 sampling occassions
par = c(1,1,1,0) # parameter values at which to calculate the negative log likelihood (nll)
nll(par, nit, K=10) # nll with K=10
nll(par, nit, K=10, SMALL_a_CORRECTION=TRUE) # nll with small a correction
}
