% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{Plot}
\alias{Plot}
\alias{Plot,ANY-method}
\alias{rePlot}
\title{\code{Plot}: Fast, optimally arranged, multi-panel plotting}
\usage{
Plot(
  ...,
  new = FALSE,
  addTo = NULL,
  gp = gpar(),
  gpText = gpar(),
  gpAxis = gpar(),
  axes = FALSE,
  speedup = 1,
  size = 5,
  cols = NULL,
  col = NULL,
  zoomExtent = NULL,
  visualSqueeze = NULL,
  legend = TRUE,
  legendRange = NULL,
  legendText = NULL,
  pch = 19,
  title = NULL,
  na.color = "#FFFFFF00",
  zero.color = NULL,
  length = NULL,
  arr = NULL,
  plotFn = "plot"
)

\S4method{Plot}{ANY}(
  ...,
  new = FALSE,
  addTo = NULL,
  gp = gpar(),
  gpText = gpar(),
  gpAxis = gpar(),
  axes = FALSE,
  speedup = 1,
  size = 5,
  cols = NULL,
  col = NULL,
  zoomExtent = NULL,
  visualSqueeze = NULL,
  legend = TRUE,
  legendRange = NULL,
  legendText = NULL,
  pch = 19,
  title = NULL,
  na.color = "#FFFFFF00",
  zero.color = NULL,
  length = NULL,
  arr = NULL,
  plotFn = "plot"
)

rePlot(toDev = dev.cur(), fromDev = dev.cur(), clearFirst = TRUE, ...)
}
\arguments{
\item{...}{A combination of \code{spatialObjects} or non-spatial objects.
For many object classes, there are specific \code{Plot} methods. Where
there are no specific ones, the base plotting will be used internally.
This means that for objects with no specific \code{Plot} methods,
many arguments, such as \code{addTo}, will not work.
See details.}

\item{new}{Logical. If \code{TRUE}, then the previous named plot area is wiped
and a new one made; if \code{FALSE}, then the \code{...} plots will be
added to the current device, adding or rearranging the plot layout
as necessary. Default is \code{FALSE}. This currently works best if
there is only one object being plotted in a given \code{Plot} call. However,
it is possible to pass a list of logicals to this, matching the
length of the \code{...} objects. Use \code{clearPlot} to clear the whole
plotting device. NOTE if \code{TRUE}: \emph{Everything that was there,
including the legend and the end points of the colour palette, will
be removed and re-initiated}.}

\item{addTo}{Character vector, with same length as \code{...}.
This is for overplotting, when the overplot is not to occur on
the plot with the same name, such as plotting a
\verb{SpatialPoints*} object on a \code{RasterLayer}.}

\item{gp}{A \code{gpar} object, created by \code{\link[=gpar]{gpar()}},
to change plotting parameters (see \pkg{grid} package).}

\item{gpText}{A \code{gpar} object for the title text.
Default \code{gpar(col = "black")}.}

\item{gpAxis}{A \code{gpar} object for the axes.
Default \code{gpar(col = "black")}.}

\item{axes}{Logical or \code{"L"}, representing the left and bottom axes, over all plots.}

\item{speedup}{Numeric. The factor by which the number of pixels is divided
by to plot rasters. See Details.}

\item{size}{Numeric. The size, in points, for \code{SpatialPoints} symbols,
if using a scalable symbol.}

\item{cols}{(also \code{col}) Character vector or list of character vectors of colours.
See details.}

\item{col}{(also \code{cols}) Alternative to \code{cols} to be consistent with \code{plot}.
\code{cols} takes precedence, if both are provided.}

\item{zoomExtent}{An \code{Extent} object. Supplying a single extent that is
smaller than the rasters will call a crop statement before
plotting. Defaults to \code{NULL}.
This occurs after any downsampling of rasters, so it may
produce very pixelated maps.}

\item{visualSqueeze}{Numeric. The proportion of the white space to be used
for plots. Default is 0.75.}

\item{legend}{Logical indicating whether a legend should be drawn.
Default is \code{TRUE}.}

\item{legendRange}{Numeric vector giving values that, representing the lower
and upper bounds of a legend (i.e., \code{1:10} or
\code{c(1,10)} will give same result) that will override
the data bounds contained within the \code{grobToPlot}.}

\item{legendText}{Character vector of legend value labels.
Defaults to \code{NULL}, which results in a pretty numeric
representation.
If \verb{Raster*} has a Raster Attribute Table (\code{rat};
see \pkg{raster} package), this will be used by default.
Currently, only a single vector is accepted.
The length of this must match the length of the legend, so
this is mostly useful for discrete-valued rasters.}

\item{pch}{see \code{?par}.}

\item{title}{Logical or character string. If logical, it
indicates whether to print the object name as the title
above the plot. If a character string, it will print this
above the plot. NOTE: the object name is used with \code{addTo},
not the title. Default NULL, which means print the object
name as title, if no other already exists on the plot, in
which case, keep the previous title.}

\item{na.color}{Character string indicating the colour for \code{NA} values.
Default transparent.}

\item{zero.color}{Character string indicating the colour for zero values,
when zero is the minimum value, otherwise, zero is
treated as any other colour. Default transparent.}

\item{length}{Numeric. Optional length, in inches, of the arrow head.}

\item{arr}{A vector of length 2 indicating a desired arrangement of plot
areas indicating number of rows, number of columns.
Default NULL, meaning
let Plot function do it automatically.}

\item{plotFn}{An optional function name to do the plotting internally, e.g.,
"barplot" to get a barplot() call. Default "plot".}

\item{toDev}{Numeric. Which device should the new replot be plotted to.
Default is current device.}

\item{fromDev}{Numeric. Which device should the replot information be taken from.
Default is current device}

\item{clearFirst}{Logical. Should \code{clearPlot} be run before replotting. Default TRUE.}
}
\value{
Invisibly returns the \code{.quickPlot} class object.
If this is assigned to an object, say \code{obj}, then this can be plotted
again with \code{Plot(obj)}.
This object is also stored in the locked \code{.quickPlotEnv}, so can simply be
replotted with \code{rePlot()} or on a new device with \code{rePlot(n)},
where \code{n} is the new device number.
}
\description{
This can take objects of type \verb{Raster*}, \verb{SpatialPoints*}, \verb{SpatialPolygons*},
and any combination of those.
These can be provided as individual objects, or a named list.
If a named list, the names either represent a different original object in the
calling environment and that will be used, or if the names don't exist in the
calling environment, then they will be copied to \code{.quickPlotEnv} for reuse later.
It can also handle \code{ggplot2} objects or \code{base::histogram} objects
created via call to \code{exHist <- hist(1:10, plot = FALSE)}. It can also take
arguments as if it were a call to \code{plot}. In this latter
case, the user should be explicit about naming the plot area using \code{addTo}.
Customization of the \code{ggplot2} elements can be done as a normal
\code{ggplot2} plot, then added with \code{Plot(ggplotObject)}.
}
\details{
\strong{NOTE:} Plot uses the \pkg{grid} package; therefore, it is NOT compatible
with base R graphics. Also, because it does not by default wipe the plotting device
before plotting, a call to \code{\link[=clearPlot]{clearPlot()}} is helpful to resolve
many errors. Careful use of the other device tools, such as \code{dev.off()} and
\code{dev.list()} might also clear problems that may arise.

If \code{new = TRUE}, a new plot will be generated, but only in the figure region that
has the same name as the object being plotted.
This is different than calling \verb{clearPlot(); Plot(Object)},
i.e,. directly before creating a new Plot. \code{clearPlot()} will clear the entire
plotting device.
When \code{new = FALSE}, any plot that already exists will be overplotted,
while plots that have not already been plotted will be added.
This function rearranges the plotting device to maximize the size of all the
plots, minimizing white space.
If using the RStudio IDE, it is recommended to make and use a new device
with \code{dev()}, because the built in device is not made for rapid redrawing.
The function is based on the grid package.

Each panel in the multipanel plot must have a name.
This name is used to overplot, rearrange the plots, or overlay using
\code{addTo} when necessary.
If the \code{...} are named \code{spatialObjects}, then \code{Plot} will use
these names. However, this name will not persist when there is a future call
to \code{Plot} that forces a rearrangement of the plots.
A more stable way is to use the object names directly, and any layer names
(in the case of \code{RasterLayer} or \code{RasterStack} objects).
If plotting a \code{RasterLayer} and the layer name is "layer" or the same as the
object name, then, for simplicity, only the object name will be used.
In other words, only enough information is used to uniquely identify the plot.

For modularity, \code{Plot} must have access to the original objects that were plotted.
These objects will be used if a subsequent Plot event forces a rearrangement of the plot device.
Rather than saving all the plot information (including the data) at each \code{Plot} call
(this is generally too much data to constantly make copies),
the function saves a pointer to the original R object. If the plot needs
to be rearranged because of a future addition, then \code{Plot} will search for that
original object that created the first plots, and replot them.
This has several consequences.
First, that object must still exist and in the same environment.
Second, if that object has changed between the first time it is plot and any
subsequent time it is replotted (via a forced rearrangement), then it will take
the object \emph{as it exists}, not as it existed. Third, if passing a named list
of objects, Plot will either create a link to objects with those names in the
calling environment (e.g., \code{.GlobalEnv}) or, if they do not exist, then \code{Plot}
will make a copy in the hidden \code{.quickPlotEnv} for later reuse.

\code{cols} is a vector of colours that can be understood directly, or by
\code{\link[grDevices:colorRamp]{colorRampPalette()}}, such as \code{c("orange", "blue")},
will give a colour range from orange to blue, interpolated.
If a list, it will be used, in order, for each item to be plotted.
It will be recycled if it is shorter than the objects to be plotted.
Note that when this approach to setting colours is used, any overplotting
will revert to the \code{colortable} slot of the object, or the default
for rasters, which is \code{terrain.color()}

\code{cols} can also accept \code{RColorBrewer} colours by keyword if it is
character vector of length 1. i.e., this cannot be used to set many objects by keyword in
the same Plot call. Default \code{terrain.color()}. See Details.

Some colouring will be automatic. If the object being plotted is a Raster, then
this will take the \code{colorTable} slot (can be changed via \code{setColors()} or other ways).
If this is a \code{SpatialPointsDataFrame}, this function will use a column called \code{colors}
and apply these to the symbols.

For \code{SpatialPolygons}, \code{cols} can accept \code{RColorBrewer} colours by keyword as a
character vector of length 1. For more control, pass a vector of colours to \code{cols} or
to \code{gp = gpar(fill = vectorOfColours)}.
In this second approach, the length of the \code{vectorOfColours} can be either less then or equal
to the number of polygons in the \code{SpatialPolygons} object -- each polygon within
a \code{Polygons} object will share the same colour -- or it can be greater than this number
to give a different colour to each \code{Polygon} (of which there can be MANY more than
\code{Polygons}. \code{Plot} will recycle these colours if there are not enough. The order
provided will be the order assigned to each \code{Polygons} or \code{Polygon} object.

Silently, one hidden object is made, \code{.quickPlot} in the
\code{.quickPlotEnv} environment, which is used for arranging plots in the
device window, and identifying the objects to be replotted if rearranging
is required, subsequent to a \code{new = FALSE} additional plot.

This function is optimized to allow modular Plotting.
This means that several behaviours will appear unusual.
For instance, if a first call to \code{Plot} is made, the legend will reflect
the current colour scheme. If a second or subsequent call to \code{Plot} is
made with the same object but with different colours (e.g., with \code{cols}),
the legend will not update. This behaviour is made with the decision that the
original layer takes precedence and all subsequent plots to that same frame
are over-plots only.

\code{speedup} is not a precise number because it is faster to plot an
non-resampled raster if the new resampling is close to the original number of
pixels.
At the moment, for rasters, this is set to 1/3 of the original pixels.
In other words, \code{speedup} will not do anything if the factor for
speeding up is not high enough (i.e., >3). If no sub-sampling is desired,
use a speedup value less than 0.1.

These \verb{gp*} parameters will specify plot parameters that are available
with \code{gpar()}. \code{gp} will adjust plot parameters, \code{gpText}
will adjust title and legend text, \code{gpAxis} will adjust the axes.
\code{size} adjusts point size in a \code{SpatialPoints} object.
These will persist with the original \code{Plot} call for each individual object.
Multiple entries can be used, but they must be named list elements and they
must match the \code{...} items to plot.
This is true for a \code{RasterStack} also, i.e., the list of named elements
must be the same length as the number of layers being plotted.
The naming convention used is: \code{RasterStackName$layerName}, i.e,
\code{landscape$DEM}.
}
\examples{
library(sp)
library(raster)
requireNamespace("rgdal") # required for raster loading
library(RColorBrewer)

files <- dir(system.file("maps", package = "quickPlot"), full.names = TRUE, pattern = "tif")
maps <- lapply(files, raster)
names(maps) <- lapply(maps, names)

# put layers into a single stack for convenience
landscape <- stack(maps$DEM, maps$forestCover, maps$forestAge,
                   maps$habitatQuality, maps$percentPine)

# can change color palette
setColors(landscape, n = 50) <- list(DEM = topo.colors(50),
                                     forestCover = brewer.pal(9, "Set1"),
                                     forestAge = brewer.pal("Blues", n = 8),
                                     habitatQuality = brewer.pal(9, "Spectral"),
                                     percentPine = brewer.pal("GnBu", n = 8))

# Make a new raster derived from a previous one; must give it a unique name
habitatQuality2 <- landscape$habitatQuality ^ 0.3
names(habitatQuality2) <- "habitatQuality2"

# make a SpatialPoints object
caribou <- sp::SpatialPoints(coords = cbind(x = stats::runif(1e2, -50, 50),
                                            y = stats::runif(1e2, -50, 50)))

# use factor raster to give legends as character strings
ras <- raster(extent(0, 3, 0, 4), vals = sample(1:4, size = 12, replace = TRUE), res = 1)

# needs to have a data.frame with ID as first column - see ?raster::ratify
levels(ras) <- data.frame(ID = 1:4, Name = paste0("Level", 1:4))
Plot(ras, new = TRUE)

# Arbitrary values for factors, including zero and not all levels represented in raster
levs <- c(0:5, 7:12)
ras <- raster(extent(0, 3, 0, 2), vals = c(1, 1, 3, 5, 8, 9), res = 1)
levels(ras) <- data.frame(ID = levs, Name = LETTERS[c(1:3, 8:16)])
Plot(ras, new = TRUE)

# Arbitrary values for factors, including zero and not all levels represented in raster
levs <- c(0:5, 7:23)
ras <- raster(extent(0, 3, 0, 2), vals = c(1, 1, 3, 5, 8, 9), res = 1)
levels(ras) <- data.frame(ID = levs, Name = LETTERS[1:23])
Plot(ras, new = TRUE)

# SpatialPolygons
sr1 <- sp::Polygon(cbind(c(2, 4, 4, 1, 2), c(2, 3, 5, 4, 2)) * 20 - 50)
sr2 <- sp::Polygon(cbind(c(5, 4, 2, 5), c(2, 3, 2, 2)) * 20 - 50)
srs1 <- sp::Polygons(list(sr1), "s1")
srs2 <- sp::Polygons(list(sr2), "s2")
spP <- sp::SpatialPolygons(list(srs1, srs2), 1:2)

clearPlot()
Plot(ras)

clearPlot()
Plot(landscape)

# Can overplot, using addTo
Plot(caribou, addTo = "landscape$forestAge", size = 4, axes = FALSE)

# can add a plot to the plotting window
Plot(caribou, new = FALSE)

# Can add two maps with same name, if one is in a stack; they are given
#  unique names based on object name
Plot(landscape, caribou, maps$DEM)

# can mix stacks, rasters, SpatialPoint*
Plot(landscape, habitatQuality2, caribou)

# can mix stacks, rasters, SpatialPoint*, and SpatialPolygons*
Plot(landscape, caribou)
Plot(habitatQuality2, new = FALSE)
Plot(spP)
Plot(spP, addTo = "landscape$forestCover", gp = gpar(lwd = 2))

# provide arrangement, NumRow, NumCol
Plot(spP, arr = c(1, 4), new = TRUE)

# example base plot
clearPlot()
Plot(1:10, 1:10, addTo = "test", new = TRUE) # if there is no "test" then it will make it
Plot(4, 5, pch = 22, col = "blue", addTo = "test")
obj1 <- rnorm(1e2)
Plot(obj1, axes = "L")

# Can plot named lists of objects (but not base objects yet)
ras1 <- ras2 <- ras
a <- list()
for (i in 1:2) {
  a[[paste0("ras", i)]] <- get(paste0("ras", i))
}
a$spP <- spP
clearPlot()
Plot(a)

# clean up
clearPlot()
}
\seealso{
\code{\link[=clearPlot]{clearPlot()}}, \code{\link[=gpar]{gpar()}}, \code{\link[=raster]{raster()}},
\code{\link[=par]{par()}}, \code{\link[=SpatialPolygons]{SpatialPolygons()}}, \code{\link[=grid.polyline]{grid.polyline()}},
\code{\link[=ggplot]{ggplot()}}, \code{\link[=dev]{dev()}}
}
\author{
Eliot McIntire
}
