% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BOW.R
\name{BOW_train}
\alias{BOW_train}
\title{Train a Bag-of-Words Model}
\usage{
BOW_train(doc, weighting_scheme = "bow", ngram_size = 1)
}
\arguments{
\item{doc}{A character vector of documents to be processed.}

\item{weighting_scheme}{A string specifying the weighting to apply. Must be one
of \code{"bow"}, \code{"binary"}, \code{"tf"}, or \code{"tfidf"}.
Defaults to \code{"bow"}.}

\item{ngram_size}{An integer specifying the maximum n-gram size. For example,
`ngram_size = 1` will create unigrams only; `ngram_size = 2` will create unigrams and bigrams. Defaults to 1.}
}
\value{
An object of class \code{"qs_bow_fit"} containing:
  \itemize{
    \item \code{dfm_template}: a quanteda \code{dfm} template
    \item \code{weighting_scheme}: the weighting used
    \item \code{ngram_size}: the n-gram size used
  }#'
}
\description{
Train a Bag-of-Words Model
}
\examples{
txt <- c("text one", "text two text")
fit <- BOW_train(txt, weighting_scheme = "bow")
fit$dfm_template

}
