% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_pop.R
\name{data_pop}
\alias{data_pop}
\title{Remove last n rows or column or specified elements from a data frame like array_pop in PHP}
\usage{
data_pop(., n = 1, which = c("rows", "cols"), ret = FALSE)
}
\arguments{
\item{.}{parent data}

\item{n}{number of elements to remove}

\item{which}{whether to remove from row or from column}

\item{ret}{TRUE or FALSE. whether to return value instead of setting it to the parent data}
}
\value{
data with elements removed
}
\description{
Shorthand to remove elements from a data frame and save as the same name
}
\examples{
#basic example: pop off 1 row from sample data
data.frame(ID=1:10,N=number(10)) #before
data_pop(data.frame(ID=1:10,N=number(10))) #after

#using data objects
data.01 <- mtcars[1:7,]

#task: remove 1 element from the end of the data and set it to the data name
data.01 #data.01 data before pop
data_pop(data.01) #does not return anything
data.01 #data.01 data updated after pop

#task: remove 3 columns from the end of the data and set it to the data name
data.01 #data.01 data before pop
data_pop(data.01, n = 3, which = "cols") #does not return anything, but updates data
data.01 #data.01 data updated after pop

#task: remove 5 elements from the end, but do not set it to the data name
data.01 #data.01 data before pop
data_pop(data.01,5, ret = TRUE) #return modified data
data.01 #data.01 data remains the same after pop


}
