% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{ppm_to_pgp}
\alias{ppm_to_pgp}
\title{Map PPM identifiers to PGP identifiers}
\usage{
ppm_to_pgp(ppm_id, verbose = FALSE, warnings = TRUE, progress_bar = TRUE)
}
\arguments{
\item{ppm_id}{A character vector of PPM identifiers,
e.g., "PPM000001".}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if
any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A data frame of two columns: \code{ppm_id} and \code{pgp_id}.
}
\description{
Map PPM identifiers to PGP identifiers.
}
\examples{
\dontrun{
ppm_to_pgp('PPM000001')
ppm_to_pgp(c('PPM000017', 'PPM000042'))
}
}
