% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_sets.R
\name{get_sample_sets}
\alias{get_sample_sets}
\title{Get PGS Catalog Sample Sets}
\usage{
get_sample_sets(
  pss_id = NULL,
  pgs_id = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pss_id}{A character vector of PGS Catalog sample sets accession
identifiers.}

\item{pgs_id}{A \code{character} vector of PGS Catalog score accession
identifiers.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how performance metrics retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same sample sets found with different
criteria.}

\item{interactive}{A logical. If all sample sets are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar indicating download
progress from the REST API server.}
}
\value{
A \linkS4class{sample_sets} object.
}
\description{
Retrieves sample sets via the PGS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all sample sets that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
associations that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search.
}
\examples{
\dontrun{
# Search by PGS identifier
get_sample_sets(pgs_id = 'PGS000013')

# Search by the PSS identifier
get_sample_sets(pss_id = 'PSS000068')
}
}
