% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qable.R
\name{qable}
\alias{qable}
\title{Qable: an extended verion of knitr::kable}
\usage{
qable(x, rgroup, rnames, cnames, markup = getOption("qwraps2_markup",
  "latex"), ...)
}
\arguments{
\item{x}{\code{matrix} or \code{data.frame} to be turned into a qable}

\item{rgroup}{a named numeric vector with the name of the row group and the
number of rows within the group.  \code{sum(rowgroup) == nrow(x)}.}

\item{rnames}{a character vector of the row names}

\item{cnames}{column names}

\item{markup}{the markup language to use}

\item{...}{additional arguments passed to \code{knitr::table}}
}
\value{
a character vector of the formatted numbers
}
\description{
Create a simple table via kable with row groups and rownames
similar to those of \code{hmisc::latex} or \code{htmlTable::htmlTable}.
}
\details{
TO DO
}
\examples{
library(dplyr)

this_summary <- function(.data) {
  summarize(.data,
            qwraps2::frmt(min(mpg)),
            qwraps2::frmt(median(mpg)),
            qwraps2::frmt(max(mpg)),
            qwraps2::frmt(min(hp)),
            qwraps2::frmt(max(hp)),
            qwraps2::frmt(mean(wt)))
}

mtcars$cyl_factor <- factor(mtcars$cyl, levels = c(4, 6, 8))

tab <- cbind(mtcars \%>\% this_summary \%>\% t,
             mtcars \%>\% group_by(cyl_factor) \%>\% this_summary \%>\% t \%>\% {.[-1, ]})

rwgrp <- c("Miles Per Gallon" = 3, "Horse Power" = 2, "Weight" = 1)
rwnms <- c("Min MPG", "Median MPG", "Max MPG", "Min HP", "Max HP", "Mean Weight")
cnms  <- c("All mtcars", paste(levels(mtcars$cyl_factor), "Cyl"))

qable(tab, rwgrp, rwnms, cnms, markup = "latex")
qable(tab, rwgrp, rwnms, cnms, markup = "markdown")
}
\seealso{
hmisc::latex, htmlTable::htmlTable
}

