% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_r2_Function.R
\name{plot_r2}
\alias{plot_r2}
\title{Generate partial contrast matrices}
\usage{
plot_r2(r2ob, txtsize = 11)
}
\arguments{
\item{r2ob}{An r2 object from the r2beta function.}

\item{txtsize}{The text size of the axis labels.}
}
\value{
A visual representation of the model and semi-partial R squared
from the r2 object provided.
}
\description{
Generate partial contrast matrices
}
\examples{
library(nlme)
library(r2glmm)

data(Orthodont)

# Linear mixed model
lmemod = lme(distance ~ age*Sex, random = ~1|Subject, data = Orthodont)

r2 = r2beta(model=lmemod,partial=TRUE,method='sgv')

plot_r2(r2ob=r2)
}

