% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2mlm_long_manual.R
\name{r2mlm_long_manual}
\alias{r2mlm_long_manual}
\title{Compute R-squared values for longitudinal multilevel models, manually
inputting parameter estimates.}
\usage{
r2mlm_long_manual(
  data,
  covs,
  random_covs,
  clusterID,
  gammas,
  Tau,
  sigma2,
  bargraph = TRUE
)
}
\arguments{
\item{data}{Dataset with rows denoting observations and columns denoting
variables}

\item{covs}{list of predictors in the dataset that have fixed components of
slopes included in the model (if none, set to NULL)}

\item{random_covs}{list of predictors in the dataset that have random
components of slopes included in the model (if none, set to NULL)}

\item{clusterID}{variable name in dataset corresponding to cluster (e.g.,
person) identification}

\item{gammas}{vector containing estimated fixed components of all slopes,
listed in the order specified in covs (if none, set to NULL)}

\item{Tau}{random effect covariance matrix; the first row and the first
column denote the intercept variance and covariances and each subsequent
row/column denotes a given random slope’s variance and covariances (to be
entered in the order listed by random_covs)}

\item{sigma2}{level-1 residual variance; can be entered as a single number,
or as a set of numbers, for example corresponding to different residual
variances at individual timepoints; if entered as a set of numbers,
function will assume equal weights and take the raw average of these to
estimate the expectation of the error variance}

\item{bargraph}{Optional bar graph output, default is TRUE.}
}
\value{
If the input is valid, then the output will be a list and associated
  graphical representation of R-squared decompositions. If the input is not
  valid, it will return an error.
}
\description{
\code{r2mlm_long_manual} takes as input raw data and  multilevel model (MLM)
parameter estimates and outputs all relevant R-squared measures as well as an
accompanying bar chart. This function extends the \code{r2mlm_manual}
function by allowing researchers to input heteroscedastic variance estimates,
and by providing level-specific measures for non-cluster-mean-centered
models.
}
\details{
This function reads in raw data as well as parameter estimates from the
researcher’s previously fit longitudinal growth model (hence, any software
program can have been used to fit the researcher’s longitudinal growth model
prior to the use of this R function, so long as parameter estimates from the
fitted model are recorded; note that this function accommodates
non-longitudinal models as well). This function then outputs R-squared
measures as well as variance decompositions and associated bar charts
outlined in Rights & Sterba (2021). This function allows researchers to input
heteroscedastic residual variance by including multiple estimates, for
example, corresponding to individual timepoints. Users need not specify if
predictors are person-mean-centered or not—the function will automatically
output total, within-person, and between-person variance attributable to each
potential source of explained variance (f1, f2, v1, v2, and m). Note,
however, that the interpretations of these sources differ for
person-mean-centered versus non-person-mean-centered models and that variance
attributable to v2 will necessarily be 0 for person-mean-centered models.
}
\examples{
# Removing cluster-mean-centering from the teachsat dataset, for
# demonstration purposes

teachsat$salary <- teachsat$salary_c + 2
uncentered_model <- lmer(satisfaction ~ salary + (1 | schoolID), data = teachsat)

r2mlm_long_manual(data = teachsat,
                  covs = c("salary"),
                  random_covs = NULL,
                  clusterID = "schoolID",
                  gammas = c(0.07430),
                  Tau = as.matrix(Matrix::bdiag(VarCorr(uncentered_model))),
                  sigma2 = getME(uncentered_model, "sigma")^2,
                  bargraph = TRUE)

}
\seealso{
Rights, J. D., & Sterba, S. K. (2021). Effect size measures for
  longitudinal growth analyses: Extending a framework of multilevel model
  R-squareds to accommodate heteroscedasticity, autocorrelation,
  nonlinearity, and alternative centering strategies. New Directions for
  Child and Adolescent Development, 2021, 65– 110. <doi:10.1002/cad.20387>

Other r2mlm single model functions: 
\code{\link{r2mlm3_manual}()},
\code{\link{r2mlm_manual}()},
\code{\link{r2mlm}()}
}
\concept{r2mlm single model functions}
