/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostDataInput;

public class XGBoostUtil {
    private XGBoostUtil() {
    }

    public static Learner loadLearner(InputStream is) throws IOException {
        return XGBoostUtil.loadLearner(is, ByteOrder.nativeOrder(), null);
    }

    public static Learner loadLearner(InputStream is, ByteOrder byteOrder, String charset) throws IOException {
        XGBoostDataInput input = new XGBoostDataInput(is, byteOrder, charset);
        Learner learner = new Learner();
        learner.load(input);
        int eof = is.read();
        if (eof != -1) {
            throw new IOException();
        }
        return learner;
    }

    public static FeatureMap loadFeatureMap(InputStream is) throws IOException {
        FeatureMap featureMap = new FeatureMap();
        Iterator<String> lines = XGBoostUtil.parseFeatureMap(is);
        int i = 0;
        while (lines.hasNext()) {
            String line = lines.next();
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException(line);
            }
            String id = st.nextToken();
            String name = st.nextToken();
            String type = st.nextToken();
            if (Integer.parseInt(id) != i) {
                throw new IllegalArgumentException(id);
            }
            featureMap.addEntry(name, type);
            ++i;
        }
        return featureMap;
    }

    private static Iterator<String> parseFeatureMap(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }
}

