/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.ScoreDistribution;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.InternableScoreDistribution;
import org.jpmml.converter.ValueUtil;

public class ScoreDistributionManager {
    private Interner<ScoreDistribution> interner = Interners.newStrongInterner();

    public List<ScoreDistribution> createScoreDistribution(CategoricalLabel categoricalLabel, double[] recordCounts) {
        ArrayList<ScoreDistribution> result = new ArrayList<ScoreDistribution>();
        for (int i = 0; i < categoricalLabel.size(); ++i) {
            Object value = categoricalLabel.getValue(i);
            double recordCount = recordCounts[i];
            ScoreDistribution scoreDistribution = new InternableScoreDistribution().setValue(value).setRecordCount(ValueUtil.narrow(recordCount));
            scoreDistribution = this.intern(scoreDistribution);
            result.add(scoreDistribution);
        }
        return result;
    }

    public ScoreDistribution intern(ScoreDistribution scoreDistribution) {
        return (ScoreDistribution)this.interner.intern((Object)scoreDistribution);
    }
}

