/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Objects;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.AbstractTransformation;
import org.jpmml.converter.PMMLUtil;

public class SigmoidTransformation
extends AbstractTransformation {
    private Number multiplier = null;

    public SigmoidTransformation(Number multiplier) {
        this.setMultiplier(multiplier);
    }

    @Override
    public Expression createExpression(FieldRef fieldRef) {
        return SigmoidTransformation.createExpression(this.getMultiplier(), fieldRef);
    }

    public Number getMultiplier() {
        return this.multiplier;
    }

    private void setMultiplier(Number multiplier) {
        this.multiplier = Objects.requireNonNull(multiplier);
    }

    public static Expression createExpression(Number multiplier, FieldRef fieldRef) {
        Number one;
        if (multiplier instanceof Float) {
            one = Float.valueOf(1.0f);
        } else if (multiplier instanceof Double) {
            one = 1.0;
        } else {
            throw new IllegalArgumentException();
        }
        return PMMLUtil.createApply("/", new Expression[]{PMMLUtil.createConstant(one), PMMLUtil.createApply("+", new Expression[]{PMMLUtil.createConstant(one), PMMLUtil.createApply("exp", new Expression[]{PMMLUtil.createApply("*", new Expression[]{PMMLUtil.createConstant(multiplier), fieldRef})})})});
    }
}

