/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.visitors.FieldUtil;
import org.jpmml.model.visitors.ActiveFieldFinder;
import org.jpmml.model.visitors.FieldResolver;

public class DeepFieldResolverUtil {
    private DeepFieldResolverUtil() {
    }

    public static Set<Field<?>> getActiveFields(FieldResolver resolver, MiningModel miningModel) {
        Collection<Field<?>> modelFields = DeepFieldResolverUtil.getModelFields(resolver, (Model)miningModel);
        LinkedHashSet activeFields = new LinkedHashSet();
        Segmentation segmentation = miningModel.getSegmentation();
        List segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Set names;
            Predicate predicate = segment.getPredicate();
            if (predicate == null || (names = ActiveFieldFinder.getFieldNames((PMMLObject[])new PMMLObject[]{predicate})).size() <= 0) continue;
            Collection segmentFields = resolver.getFields(new PMMLObject[]{miningModel, segmentation, segment});
            activeFields.addAll(FieldUtil.selectAll(segmentFields, names));
        }
        Output output = miningModel.getOutput();
        if (output != null) {
            Set names = ActiveFieldFinder.getFieldNames((PMMLObject[])new PMMLObject[]{output});
            if (names.size() > 0) {
                activeFields.addAll(FieldUtil.selectAll(modelFields, names));
            }
            activeFields.removeAll(output.getOutputFields());
        }
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                Collection segmentationFields = resolver.getFields(new PMMLObject[]{miningModel, segmentation});
                segmentationFields.removeAll(modelFields);
                activeFields.removeAll(segmentationFields);
                break;
            }
        }
        return activeFields;
    }

    public static Set<Field<?>> getActiveFields(FieldResolver resolver, Model model) {
        Collection<Field<?>> modelFields = DeepFieldResolverUtil.getModelFields(resolver, model);
        LinkedHashSet activeFields = new LinkedHashSet();
        ActiveFieldFinder activeFieldFinder = new ActiveFieldFinder(){

            public VisitorAction visit(LocalTransformations localTransformations) {
                return VisitorAction.SKIP;
            }
        };
        Set names = ActiveFieldFinder.getFieldNames((ActiveFieldFinder)activeFieldFinder, (PMMLObject[])new PMMLObject[]{model});
        activeFields.addAll(FieldUtil.selectAll(modelFields, names));
        Output output = model.getOutput();
        if (output != null) {
            activeFields.removeAll(output.getOutputFields());
        }
        return activeFields;
    }

    private static Collection<Field<?>> getModelFields(FieldResolver resolver, Model model) {
        Output output = model.getOutput();
        if (output != null && output.hasOutputFields()) {
            return resolver.getFields(new PMMLObject[]{model, output});
        }
        return resolver.getFields(new PMMLObject[]{model});
    }
}

