/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RClosure;
import org.jpmml.rexp.RDataInput;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.REnvironment;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExternalPtr;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RFunctionCall;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RRaw;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RSymbol;
import org.jpmml.rexp.S4Object;
import org.jpmml.rexp.SerializationUtil;
import org.jpmml.rexp.XDRInput;

public class RExpParser {
    private RDataInput input = null;
    private String nativeEncoding = null;
    private Map<RSymbol, REnvironment> namespaces = new LinkedHashMap<RSymbol, REnvironment>();
    private List<RExp> referenceTable = new ArrayList<RExp>();
    private static final byte[] GZIP_MAGIC = new byte[]{31, -117};

    public RExpParser(InputStream is) throws IOException {
        this.input = new XDRInput(RExpParser.init(new PushbackInputStream(is, 2)));
    }

    public RExp parse() throws IOException {
        int version = this.readInt();
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException(String.valueOf(version));
        }
        int writerVersion = this.readInt();
        int releaseVersion = this.readInt();
        if (version == 3) {
            int length = this.readInt();
            byte[] buffer = this.readByteArray(length);
            this.nativeEncoding = new String(buffer);
        }
        RExp result = this.readRExp();
        try {
            this.readInt();
            throw new IllegalStateException();
        }
        catch (EOFException eOFException) {
            return result;
        }
    }

    private RExp readRExp() throws IOException {
        int flags = this.readInt();
        int type = SerializationUtil.decodeType(flags);
        switch (type) {
            case 1: {
                return this.readSymbol();
            }
            case 2: {
                return this.readPairList(flags);
            }
            case 3: {
                return this.readClosure(flags);
            }
            case 4: {
                return this.readEnvironment(flags);
            }
            case 5: {
                return this.readPromise(flags);
            }
            case 6: {
                return this.readFunctionCall(flags);
            }
            case 9: {
                return this.readString(flags);
            }
            case 10: {
                return this.readLogicalVector(flags);
            }
            case 13: {
                return this.readIntVector(flags);
            }
            case 14: {
                return this.readRealVector(flags);
            }
            case 16: {
                return this.readStringVector(flags);
            }
            case 17: {
                return this.readEllipsis(flags);
            }
            case 19: 
            case 20: {
                return this.readVector(flags);
            }
            case 21: {
                return this.readBytecode(flags);
            }
            case 22: {
                return this.readExternalPointer(flags);
            }
            case 24: {
                return this.readRaw(flags);
            }
            case 25: {
                return this.readS4Object(flags);
            }
            case 241: {
                return null;
            }
            case 242: {
                return REnvironment.EMPTY;
            }
            case 249: {
                return this.readNamespace();
            }
            case 250: {
                return null;
            }
            case 251: {
                return RSymbol.MISSING_ARG;
            }
            case 252: {
                return null;
            }
            case 253: {
                return null;
            }
            case 254: {
                return null;
            }
            case 255: {
                return this.readReference(flags);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(type));
    }

    private RString readSymbol() throws IOException {
        RString symbol = (RString)this.readRExp();
        if (symbol.getValue() == null) {
            symbol = RString.NA;
        }
        this.referenceTable.add(symbol);
        return symbol;
    }

    private RPair readPairList(int flags) throws IOException {
        int type;
        RPair first = null;
        RPair last = null;
        while ((type = SerializationUtil.decodeType(flags)) != 254) {
            RPair attributes = this.readAttributes(flags);
            RExp tag = this.readTag(flags);
            RExp value = this.readRExp();
            RPair pair = new RPair(tag, value, attributes);
            if (first == null) {
                first = pair;
                last = pair;
            } else {
                last.setNext(pair);
                last = pair;
            }
            flags = this.readInt();
        }
        return first;
    }

    private RExp readClosure(int flags) throws IOException {
        RPair attributes = this.readAttributes(flags);
        RExp environment = this.readTag(flags);
        RPair parameters = (RPair)this.readRExp();
        RExp body = this.readRExp();
        return new RClosure(attributes, environment, parameters, body);
    }

    private REnvironment readEnvironment(int flags) throws IOException {
        REnvironment environment = new REnvironment(){};
        this.readInt();
        this.referenceTable.add(environment);
        RExp parent = this.readRExp();
        RPair frame = (RPair)this.readRExp();
        RExp hashtab = this.readRExp();
        environment.setVariables(frame);
        RPair attributes = (RPair)this.readRExp();
        environment.setAttributes(attributes);
        return environment;
    }

    private RExp readPromise(int flags) throws IOException {
        RPair attributes = this.readAttributes(flags);
        RExp environment = this.readTag(flags);
        RExp value = this.readRExp();
        RExp expression = this.readRExp();
        return null;
    }

    private RFunctionCall readFunctionCall(int flags) throws IOException {
        RPair attributes = this.readAttributes(flags);
        RExp tag = this.readTag(flags);
        RExp function = this.readRExp();
        RPair arguments = (RPair)this.readRExp();
        return new RFunctionCall(tag, function, arguments, attributes);
    }

    private RString readString(int flags) throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return new RString(null);
        }
        byte[] buffer = this.readByteArray(length);
        String value = SerializationUtil.isBytesCharset(flags) ? new String(buffer, StandardCharsets.US_ASCII) : (SerializationUtil.isLatin1Charset(flags) ? new String(buffer, StandardCharsets.ISO_8859_1) : (SerializationUtil.isUTF8Charset(flags) ? new String(buffer, StandardCharsets.UTF_8) : new String(buffer)));
        return new RString(value);
    }

    private RBooleanVector readLogicalVector(int flags) throws IOException {
        int length = this.readInt();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            int value;
            values[i] = value = this.readInt();
        }
        return new RBooleanVector(values, this.readAttributes(flags));
    }

    private RIntegerVector readIntVector(int flags) throws IOException {
        int length = this.readInt();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            int value;
            values[i] = value = this.readInt();
        }
        RIntegerVector result = new RIntegerVector(values, this.readAttributes(flags));
        if (result.hasAttribute("levels")) {
            result = new RFactorVector(values, result.getAttributes());
        }
        return result;
    }

    private RDoubleVector readRealVector(int flags) throws IOException {
        int length = this.readInt();
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            double value;
            values[i] = value = this.readDouble();
        }
        return new RDoubleVector(values, this.readAttributes(flags));
    }

    private RStringVector readStringVector(int flags) throws IOException {
        int length = this.readInt();
        ArrayList<String> values = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            RString string = (RString)this.readRExp();
            values.add(string.getValue());
        }
        return new RStringVector(values, this.readAttributes(flags));
    }

    private RExp readEllipsis(int flags) throws IOException {
        RPair attributes = this.readAttributes(flags);
        RExp environment = this.readTag(flags);
        RExp value = this.readRExp();
        RExp expression = this.readRExp();
        return null;
    }

    private RGenericVector readVector(int flags) throws IOException {
        int length = this.readInt();
        ArrayList<RExp> values = new ArrayList<RExp>(length);
        for (int i = 0; i < length; ++i) {
            RExp rexp = this.readRExp();
            values.add(rexp);
        }
        return new RGenericVector(values, this.readAttributes(flags));
    }

    private RExp readBytecode(int flags) throws IOException {
        int length = this.readInt();
        RExp[] reps = new RExp[length];
        return this.readBC1(reps);
    }

    private RExp readExternalPointer(int flags) throws IOException {
        RExternalPtr externalPtr = new RExternalPtr(null);
        this.referenceTable.add(externalPtr);
        RExp protected_ = this.readRExp();
        RExp tag = this.readRExp();
        RPair attributes = this.readAttributes(flags);
        externalPtr.setAttributes(attributes);
        return externalPtr;
    }

    private RRaw readRaw(int flags) throws IOException {
        int length = this.readInt();
        byte[] value = this.readByteArray(length);
        return new RRaw(value, this.readAttributes(flags));
    }

    private RExp readBC1(RExp[] reps) throws IOException {
        RExp code = this.readRExp();
        RExp[] constants = this.readBCConsts(reps);
        return constants[0];
    }

    private RExp[] readBCConsts(RExp[] reps) throws IOException {
        int n = this.readInt();
        RExp[] pool = new RExp[n];
        block5: for (int i = 0; i < n; ++i) {
            int type = this.readInt();
            switch (type) {
                case 2: 
                case 6: {
                    pool[i] = this.readBCLang(type, reps);
                    continue block5;
                }
                case 21: {
                    pool[i] = this.readBC1(reps);
                    continue block5;
                }
                case 239: 
                case 240: 
                case 243: 
                case 244: {
                    pool[i] = this.readBCLang(type, reps);
                    continue block5;
                }
                default: {
                    pool[i] = this.readRExp();
                }
            }
        }
        return pool;
    }

    private RExp readBCLang(int type, RExp[] reps) throws IOException {
        switch (type) {
            case 2: 
            case 6: 
            case 239: 
            case 240: 
            case 244: {
                RPair pair;
                RPair attributes;
                int pos = -1;
                if (type == 244) {
                    pos = this.readInt();
                    type = this.readInt();
                }
                switch (type) {
                    case 239: 
                    case 240: {
                        attributes = this.readAttributes();
                        break;
                    }
                    default: {
                        attributes = null;
                    }
                }
                switch (type) {
                    case 2: 
                    case 239: {
                        pair = new RPair(null, null, attributes);
                        break;
                    }
                    case 6: 
                    case 240: {
                        pair = new RFunctionCall(null, null, null, attributes);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(type));
                    }
                }
                if (pos >= 0) {
                    reps[pos] = pair;
                }
                RExp tag = this.readRExp();
                pair.setTag(tag);
                RExp value = this.readBCLang(this.readInt(), reps);
                pair.setValue(value);
                RPair next = (RPair)this.readBCLang(this.readInt(), reps);
                if (next != null) {
                    pair.setNext(next);
                }
                return pair;
            }
            case 243: {
                return reps[this.readInt()];
            }
        }
        return this.readRExp();
    }

    private S4Object readS4Object(int flags) throws IOException {
        return new S4Object(this.readAttributes(flags));
    }

    private RExp readNamespace() throws IOException {
        int flags = this.readInt();
        if (flags != 0) {
            throw new UnsupportedOperationException();
        }
        RStringVector name = this.readStringVector(flags);
        RSymbol symbol = new RSymbol(name.getValue(0));
        REnvironment namespace = this.namespaces.get(symbol);
        if (namespace == null) {
            namespace = new REnvironment(){};
            this.namespaces.put(symbol, namespace);
        }
        this.referenceTable.add(namespace);
        return namespace;
    }

    private RExp readReference(int flags) throws IOException {
        int refIndex = SerializationUtil.unpackRefIndex(flags);
        if (refIndex == 0) {
            refIndex = this.readInt();
        }
        return this.referenceTable.get(refIndex - 1);
    }

    private RExp readTag(int flags) throws IOException {
        if (SerializationUtil.hasTag(flags)) {
            return this.readRExp();
        }
        return null;
    }

    private RPair readAttributes(int flags) throws IOException {
        if (SerializationUtil.hasAttributes(flags)) {
            return this.readAttributes();
        }
        return null;
    }

    private RPair readAttributes() throws IOException {
        return (RPair)this.readRExp();
    }

    private int readInt() throws IOException {
        return this.input.readInt();
    }

    private double readDouble() throws IOException {
        return this.input.readDouble();
    }

    private byte[] readByteArray(int length) throws IOException {
        return this.input.readByteArray(length);
    }

    private static InputStream init(PushbackInputStream is) throws IOException {
        byte[] gzipMagic = new byte[2];
        ByteStreams.readFully((InputStream)is, (byte[])gzipMagic);
        is.unread(gzipMagic);
        if (Arrays.equals(GZIP_MAGIC, gzipMagic)) {
            return new GZIPInputStream(is);
        }
        return is;
    }
}

