## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(r2r)

## ----example------------------------------------------------------------------
m <- hashmap()

## -----------------------------------------------------------------------------
m[["key"]] <- "value"
m[c(1, 2, 3)] <- c("a", "b", "c") # Vectorized over keys and values
m[[c(4, 5, 6)]] <- c("d", "e", "f") # Not vectorized

## -----------------------------------------------------------------------------
m[["key"]]

m[c(1, 2, 3)]
m[[c(1, 2, 3)]]

m[c(4, 5, 6)]
m[[c(4, 5, 6)]]

## -----------------------------------------------------------------------------
insert(m, "user", "vgherard") # Modifies `m` in place
query(m, "user")

## -----------------------------------------------------------------------------
s <- hashset()
insert(s, 1)
s[[2]] <- T # equivalent to insert(s, 2)
s[c(1, 2, 3)]

## -----------------------------------------------------------------------------
m[[ lm(wt ~ mpg, mtcars) ]] <- list("This is my fit!", 840)
m[[ lm(wt ~ mpg, mtcars) ]]
m[[ lm(cyl ~ mpg, mtcars) ]]

## -----------------------------------------------------------------------------
m <- hashmap(default = 0)

## -----------------------------------------------------------------------------
objects <- list(1, 1, "1", FALSE, "1", 1)
for (object in objects)
	m[[object]] <- m[[object]] + 1
m[["1"]]

## -----------------------------------------------------------------------------
m <- hashmap(on_missing_key = "throw")
tryCatch(m[["Missing key"]], error = function(cnd) "Oops!")

## -----------------------------------------------------------------------------
m <- hashmap()
m[[1]] <- "double"
m[["1"]] <- "character"
m[[1]]

## -----------------------------------------------------------------------------
m <- hashmap(key_preproc_fn = Arg)

## -----------------------------------------------------------------------------
m[list(1, 1 + 1i, 1i)] <- list("EAST", "NORTH-EAST", "NORTH")
m[[10]]
m[[100i]]
m[[2 + 2i]]

