% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisqTest.R
\name{chisqTest}
\alias{chisqTest}
\alias{print.chisqTestSPSS}
\title{\eqn{\chi^{2}}{Chi-squared} Tests}
\usage{
chisqTest(data, variables, p = NULL)

\method{print}{chisqTestSPSS}(x, digits = c(1, 3), statistics = c("frequencies", "test"), ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying the categorical variable(s)
of interest.  If only one variable is specified, a goodness-of-fit test is
performed.  If two variables are specified, a test on independence is
performed (with the first variable used for the rows and the second variable
for the columns of the crosstabulation).}

\item{p}{a vector of probabilities for the categories in the
goodness-of-fit test.}

\item{x}{an object of class \code{"chisqTestSPSS"} as returned by function
\code{chisqTest}.}

\item{digits}{an integer vector giving the number of digits after the comma
to be printed in the LaTeX tables.  The first element corresponds to the
number of digits in the table of frequencies, and the second element
corresponds to the number of digits in the table for the test.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"frequencies"} for a table of the
observed and expected frequencies, and \code{"test"} for test results.  The
default is to print both tables.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"chisqTestSPSS"} with the following components:
\describe{
  \item{\code{chisq}}{a list containing the results of the
  \eqn{\chi^{2}}{chi-squared} test.}
  \item{\code{lr}}{a list containing the results of a likelihood ratio
  test (only test on independence).}
  \item{\code{observed}}{a table containing the observed frequencies.}
  \item{\code{expected}}{a vector or matrix containing the expected
  frequencies.}
  \item{\code{n}}{an integer giving the number of observations.}
  \item{\code{k}}{an integer giving the number of groups (only
  goodness-of-fit test).}
  \item{\code{r}}{an integer giving the number of groups in the first
  variable corresponding to the rows (only test on independence).}
  \item{\code{c}}{an integer giving the number of groups in the second
  variable corresponding to the columns (only test on independence).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  categorical variable(s) of interest.}
  \item{\code{type}}{a character string giving the type of
  \eqn{\chi^{2}}{chi-squared} test performed (\code{"goodness-of-fit"}
  or \code{"independence"}).}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Perform a \eqn{\chi^{2}}{chi-squared} goodness-of-fit test or a
\eqn{\chi^{2}}{chi-squared} test on independence on variables of
a data set.  The output is printed as a LaTeX table that mimics
the look of SPSS output (version <24).
}
\note{
The test on independence also reports the results of a likelihood
ratio test.
}
\examples{
# load data
data("Eredivisie")

# test whether playing position and dummy variable for
# foreign players are independent
chisqTest(Eredivisie, c("Position", "Foreign"))

# test whether the traditional Dutch 4-3-3 (total football)
# is still reflected in player composition
chisqTest(Eredivisie, "Position", p = c(1, 4, 3, 3)/11)

}
\author{
Andreas Alfons
}
\keyword{htest}
