% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SStableComparisons}
\alias{SStableComparisons}
\title{make table comparing quantities across models}
\usage{
SStableComparisons(summaryoutput, models = "all", likenames = c("TOTAL",
  "Survey", "Length_comp", "Age_comp", "priors", "Size_at_age"),
  names = c("R0", "steep", "NatM", "Q_calc", "L_at_Amax", "VonBert_K",
  "RecrDev_2008", "SPB_Virg", "Bratio_2012", "SPRratio_2011"), digits = NULL,
  modelnames = "default", csv = FALSE, csvdir = "workingdirectory",
  csvfile = "parameter_comparison_table.csv", verbose = TRUE,
  mcmc = FALSE)
}
\arguments{
\item{summaryoutput}{list created by \code{SSsummarize}}

\item{models}{optional subset of the models described in
\code{summaryoutput}.  Either "all" or a vector of numbers indicating
columns in summary tables.}

\item{likenames}{Labels for likelihood values to include, should match
substring of labels in \code{summaryoutput$likelihoods}.}

\item{names}{Labels for parameters or derived quantities to include, should
match substring of labels in \code{summaryoutput$pars} or
\code{summaryoutput$quants}.}

\item{digits}{Optional vector of the number of decimal digits to use in
reporting each quantity.}

\item{modelnames}{optional vector of labels to use as column names. Default
is 'model1','model2',etc.}

\item{csv}{write resulting table to CSV file?}

\item{csvdir}{directory for optional CSV file}

\item{csvfile}{filename for CSV file}

\item{verbose}{report progress to R GUI?}

\item{mcmc}{summarize MCMC output in table?}
}
\description{
Creates a table comparing key quantities from multiple models, which is a
reduction of the full information in various parts of the list created using
the \code{SSsummarize} function.
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SSsummarize}}, \code{\link{SSplotComparisons}},
\code{\link{SS_output}}
}
\keyword{data}

