% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotNumbers.R
\name{SSplotNumbers}
\alias{SSplotNumbers}
\title{Plot numbers-at-age related data and fits.}
\usage{
SSplotNumbers(replist, subplots = 1:10, plot = TRUE, print = FALSE,
  numbers.unit = 1000, areas = "all", areanames = "default",
  areacols = "default", pntscalar = 2.6, bub.bg = gray(0.5, alpha =
  0.5), bublegend = TRUE, period = c("B", "M"), add = FALSE,
  labels = c("Year", "Age", "True age (yr)", "SD of observed age (yr)",
  "Mean observed age (yr)", "Mean age (yr)", "mean age in the population",
  "Ageing imprecision", "Numbers at age at equilibrium",
  "Equilibrium age distribution", "Fraction female in numbers at age",
  "Length", "Mean length (cm)", "mean length (cm) in the population",
  "expected numbers at age", "Beginning of year", "Middle of year",
  "expected numbers at length", "Fraction female in numbers at length"),
  pwidth = 6.5, pheight = 5, punits = "in", res = 300,
  ptsize = 10, cex.main = 1, plotdir = "default",
  mainTitle = FALSE, verbose = TRUE)
}
\arguments{
\item{replist}{list created by \code{SSoutput}}

\item{subplots}{vector controlling which subplots to create}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{numbers.unit}{Units for numbers. Default (based on typical Stock Synthesis
setup) is thousands (numbers.unit=1000).}

\item{areas}{optional subset of areas to plot for spatial models}

\item{areanames}{names for areas. Default is to use Area1, Area2,...}

\item{areacols}{vector of colors by area}

\item{pntscalar}{maximum bubble size for bubble plots; each plot scaled
independently based on this maximum size and the values plotted. Often some
plots look better with one value and others with a larger or smaller value.
Default=2.6}

\item{bub.bg}{background color for bubbles
(no control over black border at this time)}

\item{bublegend}{Add legend with example bubble sizes?}

\item{period}{indicator of whether to make plots using numbers at age just
from the beginning ("B") or middle of the year ("M") (new option starting
with SSv3.11)}

\item{add}{add to existing plot? (not yet implemented)}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{pwidth}{width of plot}

\item{pheight}{height of plot}

\item{punits}{units for PNG file}

\item{res}{resolution for PNG file}

\item{ptsize}{point size for PNG file}

\item{cex.main}{character expansion for plot titles}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{mainTitle}{Logical indicating if a title should be included at the top}

\item{verbose}{report progress to R GUI?}
}
\description{
Plot numbers-at-age related data and fits from Stock Synthesis output.
Plots include bubble plots, mean age, equilibrium age composition,
sex-ratio, and ageing imprecision patterns.
}
\seealso{
\code{\link{SS_output}}, \code{\link{SS_plots}}
}
\author{
Ian Stewart, Ian Taylor
}
