/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.FreeFormPointSet;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.transit.TransportNetwork;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5MultiDestinationProcess;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;

public class TravelTimeMatrixComputer
extends R5MultiDestinationProcess {
    private FreeFormPointSet destinationPoints = null;

    public TravelTimeMatrixComputer(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    public List<LinkedHashMap<String, ArrayList<Object>>> run() throws ExecutionException, InterruptedException {
        this.buildDestinationPointSet();
        return super.run();
    }

    /*
     * WARNING - void declaration
     */
    private void buildDestinationPointSet() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        DataOutputStream pointStream = new DataOutputStream(dataStream);
        try {
            void var3_7;
            pointStream.writeInt(this.toIds.length);
            for (String toId : this.toIds) {
                pointStream.writeUTF(toId);
            }
            for (double toLat : this.toLats) {
                pointStream.writeDouble(toLat);
            }
            for (double toLon : this.toLons) {
                pointStream.writeDouble(toLon);
            }
            boolean bl = false;
            while (var3_7 < this.toIds.length) {
                pointStream.writeDouble(1.0);
                ++var3_7;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataStream.toByteArray());
        try {
            this.destinationPoints = new FreeFormPointSet((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.directModes.isEmpty()) {
            for (LegMode mode : this.directModes) {
                this.transportNetwork.linkageCache.getLinkage((PointSet)this.destinationPoints, this.transportNetwork.streetLayer, StreetMode.valueOf((String)mode.toString()));
            }
        }
    }

    @Override
    protected LinkedHashMap<String, ArrayList<Object>> runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        request.percentiles = this.routingProperties.percentiles;
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index]);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable.getDataFrame();
        }
        return null;
    }

    private void populateDataFrame(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        for (int i = 0; i < travelTimeResults.travelTimes.nPoints; ++i) {
            if (travelTimeResults.travelTimes.getValues()[0][i] > this.maxTripDuration) continue;
            travelTimesTable.append();
            travelTimesTable.set("toId", this.toIds[i]);
            if (this.routingProperties.percentiles.length == 1) {
                travelTimesTable.set("travel_time", travelTimeResults.travelTimes.getValues()[0][i]);
                continue;
            }
            for (int p = 0; p < this.routingProperties.percentiles.length; ++p) {
                int tt = travelTimeResults.travelTimes.getValues()[p][i];
                String ps = String.format("%03d", this.routingProperties.percentiles[p]);
                if (tt >= this.maxTripDuration) continue;
                travelTimesTable.set("travel_time_p" + ps, tt);
            }
        }
    }

    private RDataFrame buildDataFrameStructure(String fromId) {
        RDataFrame travelTimesTable = new RDataFrame();
        travelTimesTable.addStringColumn("fromId", fromId);
        travelTimesTable.addStringColumn("toId", "");
        if (this.routingProperties.percentiles.length == 1) {
            travelTimesTable.addIntegerColumn("travel_time", Integer.MAX_VALUE);
        } else {
            for (int p : this.routingProperties.percentiles) {
                String ps = String.format("%03d", p);
                travelTimesTable.addIntegerColumn("travel_time_p" + ps, Integer.MAX_VALUE);
            }
        }
        return travelTimesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = this.destinationPoints;
        return request;
    }
}

