% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit_network_to_sf.R
\name{transit_network_to_sf}
\alias{transit_network_to_sf}
\title{Extract transit network in sf format}
\usage{
transit_network_to_sf(r5r_core)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}
}
\value{
A list with two components of a transit network in \code{sf} format:
route shapes (\code{LINESTRING}) and transit stops (\code{POINT}). The same
\code{route_id}/\code{short_name} might appear with different geometries. This occurs
when the same route is associated to more than one \code{shape_id}s in the GTFS
feed used to create the transit network. Some transit stops might be
returned with geometry \verb{POINT EMPTY} (i.e. missing spatial coordinates).
This may occur when a transit stop is not snapped to the road network,
possibly because the GTFS feed used to create the transit network covers an
area larger than the \code{.osm.pbf} input data.
}
\description{
Extracts the transit network from a \code{network.dat} file (built with
\code{\link[=setup_r5]{setup_r5()}}) in \code{sf} format.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(r5r)

# build transport network
path <- system.file("extdata/poa", package = "r5r")
r5r_core <- setup_r5(path)

# extract transit network from r5r_core
transit_net <- transit_network_to_sf(r5r_core)

stop_r5(r5r_core)
\dontshow{\}) # examplesIf}
}
\seealso{
Other network functions: 
\code{\link{find_snap}()},
\code{\link{street_network_to_sf}()}
}
\concept{network functions}
