% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmChart.R, R/AmChart_constructors.R
\docType{methods}
\name{initialize,AmChart-method}
\alias{amAngularGaugeChart}
\alias{amChart}
\alias{amFunnelChart}
\alias{amGanttChart}
\alias{amPieChart}
\alias{amRadarChart}
\alias{amSerialChart}
\alias{amXYChart}
\alias{initialize,AmChart-method}
\title{Create an AmChart}
\usage{
\S4method{initialize}{AmChart}(.Object, allLabels, arrows, axes, balloon,
  categoryAxis, categoryField, chartCursor, chartScrollbar, creditsPosition,
  dataProvider, graphs, graph, guides, legend, segmentsField, theme, titles,
  trendLines, type, valueAxes, valueAxis,
  pathToImages = "http://www.amcharts.com/lib/3/images/", ...)

amChart(allLabels, arrows, axes, balloon, categoryAxis, categoryField,
  chartCursor, chartScrollbar, creditsPosition, dataProvider, graph, graphs,
  guides, legend, segmentsField, theme, titles, trendLines, type, valueAxes,
  valueAxis, pathToImages = "http://www.amcharts.com/lib/3/images/", ...)

amAngularGaugeChart(arrows, titles, axes, ...)

amFunnelChart(dataProvider, ...)

amRadarChart(allLabels, balloon, categoryField, creditsPosition, dataProvider,
  graphs, guides, legend, titles, valueAxes, ...)

amSerialChart(allLabels, balloon, categoryAxis, categoryField, chartCursor,
  chartScrollbar, creditsPosition, dataProvider, graphs, guides, legend, titles,
  trendLines, valueAxes, ...)

amPieChart(allLabels, balloon, creditsPosition, dataProvider, legend, titles,
  ...)

amGanttChart(categoryField, dataProvider, graph, segmentsField, valueAxis, ...)

amXYChart(creditsPosition, dataProvider, graphs, ...)
}
\arguments{
\item{.Object}{\code{\linkS4class{AmChart}}}

\item{allLabels}{\code{list}. List of \linkS4class{Label}s.}

\item{arrows}{\code{list}
containing object of class \code{\linkS4class{GaugeArrow}}.}

\item{axes}{\code{list} of \linkS4class{GaugeAxis}.}

\item{balloon}{\code{list} of \linkS4class{AmBalloon}.
Creates the balloons (tooltips) of the chart,
It follows the mouse cursor when you roll-over the data items.
The framework generates the instances automatically you only need to adjust
the appearance to your needs.}

\item{categoryAxis}{\code{list} of \linkS4class{CategoryAxis}.
Read-only. Chart creates category axis itself.
If you want to change some properties,
you should get this axis from the chart and set properties to this object.}

\item{categoryField}{\code{character}.
Category field name tells the chart the name of the field in your dataProvider object
which will be used for category axis values.}

\item{chartCursor}{\linkS4class{ChartCursor}.}

\item{chartScrollbar}{\linkS4class{ChartScrollbar}.
Properties of chart's scrollbar.}

\item{creditsPosition}{\code{character},
specifying position of link to amCharts site.
Allowed values are: top-left, top-right, bottom-left and bottom-right.}

\item{dataProvider}{\code{list}, containing the data.
Use providing method toList* to convert a \code{data.frame}.}

\item{graphs}{\code{list} of \linkS4class{AmGraph}
Creates the visualization of the data in following types: line, column, step line,
smoothed line, olhc and candlestick.}

\item{graph}{code{\linkS4class{AmGraph}}.
Graph of a Gantt chart. Gant chart actually creates multiple graphs
(separate for each segment).
Properties of this graph are passed to each of the created graphs
- this allows you to control the look of segments.}

\item{guides}{\code{list} of \linkS4class{Guide}.}

\item{legend}{\linkS4class{AmLegend}.
Properties of chart's legend.}

\item{segmentsField}{\code{character}.}

\item{theme}{\code{character}.
Theme of a chart. Config files of themes can be found in amcharts/themes/ folder.}

\item{titles}{\code{list} of \linkS4class{Title}.}

\item{trendLines}{\code{list} of \linkS4class{TrendLine}.
You can add trend lines to a chart using this list or access already existing trend lines.}

\item{type}{\code{character}.
Possible types are: serial, pie, radar,
(types xy, radar, funnel, gauge, map, stock. are in development).}

\item{valueAxes}{\code{list} of \linkS4class{ValueAxis} properties.
Chart creates one value axis automatically,
so if you need only one value axis, you don't need to create it.}

\item{valueAxis}{\linkS4class{ValueAxis} for Gantt chart.
Set it's type to "date" if your data is date or time based.
In case of Value axis for a Gantt chart.
Set it's type to "date" if your data is date or time based.}

\item{pathToImages}{\code{character}}

\item{...}{Other properties of \linkS4class{AmChart}.
See \url{http://docs.amcharts.com/3/javascriptstockchart/AmChart}.}
}
\value{
Returns an object of class \linkS4class{AmChart} with arguments.
}
\description{
Method for initializing any S4 class provided by the package.
}
\details{
amAngularGaugeChart is a shortcut for instantiating AmChart of type \code{gauge}

amFunnelChart is a shortcut
for instantiating AmChart of type \code{funnel}

amRadarChart is a shortcut
for instantiating AmChart of type \code{radar}

amSerialChart is a shortcut constructor
for instantiating AmChart of type \code{serial}

amPieChart is a shortcut constructor
for instantiating AmChart of type \code{pie}

amGanttChart is a constructor
for instantiating AmChart of type \code{gantt}

amXYChart is a shortcut constructor
for instantiating AmChart of type \code{xy}
}
\section{Functions}{
\itemize{
\item \code{amChart}: 

\item \code{amAngularGaugeChart}: 

\item \code{amFunnelChart}: 

\item \code{amRadarChart}: 

\item \code{amSerialChart}: 

\item \code{amPieChart}: 

\item \code{amGanttChart}: 

\item \code{amXYChart}: 
}}
\examples{
new("AmChart", valueField = "value")
amChart(type = "pie")
amAngularGaugeChart()
amFunnelChart(marginLeft = 15)
amRadarChart()
amSerialChart(creditsPostion = "top-right")
amPieChart()
amGanttChart(segmentsField = "segments")
amXYChart()
}
\seealso{
\linkS4class{AmChart} S4 class
}

