% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amHist.R
\name{amHist}
\alias{amHist}
\alias{amHist.numeric}
\title{Plotting histogram using rAmCharts}
\usage{
amHist(x, ...)

\method{amHist}{numeric}(x, col = "#1e90ff", border = "#1e90ff",
  freq = TRUE, plot = TRUE, labels = FALSE, xlab, ylab, ylim,
  control_hist, ...)
}
\arguments{
\item{x}{\code{numeric}, a vector of values for which the histogram is desired.}

\item{...}{see \code{\link{amOptions}} for more options.}

\item{col}{\code{character}, a color to be used to fill the bars.}

\item{border}{\code{character}, a color for the borders.}

\item{freq}{\code{logical}, if \code{TRUE}, the histogram graphic is a representation of frequencies,
the counts component of the result; if FALSE, probability densities,
component density, are plotted (so that the histogram has a total area of one).
Defaults to TRUE if and only if breaks are equidistant (and probability is not specified).}

\item{plot}{\code{logical}, if \code{TRUE} (default),
an histogram is plotted, otherwise a list of breaks and counts is returned.
In the second case, a warning is used if (typically graphical)
arguments are specified that only apply to the \code{plot = TRUE} case.}

\item{labels}{\code{logical}, set to TRUE to display labels. Default set to FALSE.
Additionally draw labels on top of bars.
if TRUE, draw the counts or rounded densities;
if labels is a \code{character}, draw itself.}

\item{xlab, ylab}{\code{character}, labels of the axis.}

\item{ylim}{\code{numeric}, the range of y values with sensible defaults.}

\item{control_hist}{(optional) named \code{list()} containing parameters to compute the histogram.}
}
\value{
An object of class \linkS4class{AmChart}.
}
\description{
amHist computes a histogram of the given data values.
}
\examples{
amHist(x = rnorm(100))

\donttest{
# Other examples available which can be time consuming depending on your configuration.

x <- replicate(1000, {
if (round(runif(1))) {
  rnorm(1)
} else {
  rnorm(1, mean = 5)
}
})


# Without plot
amHist(x = x, plot = FALSE)

# With options
amHist(x = x, border = "blue")
amHist(x = x, col = "lightblue", control_hist = list(breaks = 100))
amHist(x = x, col = "grey")
amHist(x = x, col = "gray")
amHist(x = x, main = "Histogram", ylab = "y-axis", xlab = "x-axis", col = "red")
amHist(x = x, main = "Histogram", ylab = "y-axis", xlab = "x-axis", ylim = c(10, 15))
amHist(x = x, main = "Histogram", ylab = "y-axis", xlab = "x-axis")

# Options for computing the histogram
amHist(x = x, control_hist = list(breaks = "Scott"))
}

}
\seealso{
\itemize{
\item{\url{https://datastorm-open.github.io/introduction_ramcharts/}}
}
}
