% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/am_simulate.R
\name{am_simulate}
\alias{am_simulate}
\title{Simulate genotype/phenotype data under equilibrium univariate AM.}
\usage{
am_simulate(h2_0, r, m, n, afs = NULL, min_MAF = 0.1, haplotypes = FALSE)
}
\arguments{
\item{h2_0}{generation zero (panmictic) heritability}

\item{r}{cross-mate phenotypic correlation}

\item{m}{number of biallelic causal variants}

\item{n}{sample size}

\item{afs}{(optional). Allele frequencies to use. If not provided, \code{m} will be drawn
uniformly from the interval [\code{min_MAF}, 1-\code{min_MAF}]}

\item{min_MAF}{(optional) minimum minor allele frequency for causal variants.
Ignored if if \code{afs} is not NULL. Defaults to 0.1}

\item{haplotypes}{logical. If TRUE, includes (phased) haploid genotypes in output.
Defaults to FALSE}
}
\value{
A list including the following objects:
\itemize{
\item \code{y}: phenotype vector
\item \code{g}: heritable component of the phenotype vector
\item \code{X}: matrix of diploid genotypes
\item \code{AF}: vector of allele frequenices
\item \code{beta_std}: standardized genetic effects
\item \code{beta_raw}: unstandardized genetic effects
\item \code{H}: matrix of haploid genotypes (returned only if \code{haplotypes}=TRUE)
}
}
\description{
Simulate genotype/phenotype data under equilibrium univariate AM.
}
\examples{
set.seed(1)
h2_0 = .5; m = 200; n = 1000; r =.5

## simulate genotype/phenotype data
sim_dat <- am_simulate(h2_0, r, m, n)
str(sim_dat)

## empirical h2 vs expected equilibrium h2
(emp_h2 <- var(sim_dat$g)/var(sim_dat$y))
h2_eq(r, h2_0)
}
