% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_events.R
\name{select_events}
\alias{select_events}
\title{Extracts From the database}
\usage{
select_events(db = NULL, tab, columns = "*", where = NULL,
  sql_only = FALSE, convert_dates = FALSE)
}
\arguments{
\item{db}{a database connection}

\item{tab}{the database table to extract from}

\item{columns}{character vector of columns to extract from the table "*" means all tables}

\item{where}{string representation of the selection criteria}

\item{sql_only}{logical should the function just return a string of the SQL query?}

\item{convert_dates}{logical should date fields be converted to R date format?}
}
\value{
a dataframe or a string representing an sql query
}
\description{
This is a generic function for extracting EHR data from the database
}
\details{
The function is the base function for a range of others
It can either extract by itself or generate the SQL to make a query.  
In this way it can be combined to make compound queries.
The where argument is equivalent to the WHERE clause in sql
The elements are converted to SQL using dplyr::translate_sql_
If an element is wrapped in a `.()`, the element is expanded.
Dates should be entered as strings in ISO format (%Y-%m-%d)
}
\examples{
\dontrun{
# medical lookup tables are provided with CPRD
load("data/medical.RData")
a <- read.csv("data/chronic-renal-disease.csv")
a <- read_to_medcodes(a, medical, "code", lookup_readcodes= "readcode", 
lookup_medcodes="medcode", description = T)
b <- select_events(db, tab = "Referral", columns = c("patid", "eventdate", "medcode"), 
where = "medcode \%in\% .(a$medcode) & eventdate < '2000-01-01'")
b1 <- select_events(db, tab = "Clinical", columns = c("patid", "eventdate", "medcode"), 
where = "medcode \%in\% .(a$medcode) & eventdate < '2000-01-01'")
}
}

