% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.R
\name{ena}
\alias{ena}
\title{TBD}
\usage{
ena(data, codes, units, conversation, metadata = NULL,
  model = c("EndPoint", "AccumulatedTrajectory", "SeparateTrajectory"),
  weight.by = "binary", window = c("MovingStanzaWindow",
  "Conversation"), window.size.back = 1, window.size.forward = 0,
  mask = NULL, include.meta = TRUE, groupCol = NULL, group1 = NULL,
  group2 = NULL, showPlots = TRUE, ...)
}
\arguments{
\item{data}{A data frame}

\item{codes}{Column names of data by which codes will be identified}

\item{units}{Column names of data by which units will be identified}

\item{conversation}{Column names of data by which conversations will be identified}

\item{metadata}{(optional) Column names of data identifying metadata to be associated with each unit in the data}

\item{model}{A character, choices: EndPoint (or E), AccumulatedTrajectory (or A), or SeparateTrajectory (or S); default: EndPoint. Determines the ENA model to be constructed}

\item{weight.by}{(optional) A function to apply to values after accumulation}

\item{window}{A character, choices are Conversation (or C), MovingStanzaWindow (MSW, MS); default MovingStanzaWindow. Determines how stanzas are constructed, which defines how co-occurrences are modeled}

\item{window.size.back}{A positive integer, Inf, or character (INF or Infinite), default: 1. Determines, for each line in the data frame, the number of previous lines in a conversation to include in the stanza window, which defines how co-occurrences are modeled}

\item{window.size.forward}{(optional) A positive integer, Inf, or character (INF or Infinite), default: 0. Determines, for each line in the data frame, the number of subsequent lines in a conversation to include in the stanza window, which defines how co-occurrences are modeled}

\item{mask}{(optional) A binary matrix of size ncol(codes) x ncol(codes). 0s in the mask matrix row i column j indicates that co-occurrence will not be modeled between code i and code j}

\item{include.meta}{Locigal indicating if unit metadata should be attached to the resulting ENAdata object, default is TRUE}

\item{groupCol}{(optional) Column name of data that includes values you wish to group and plot units by. Default is to plot a mean network for all units.}

\item{group1}{(optional) Value of groupCol that you wish to group and plot units by}

\item{group2}{(optional) Value of groupCol that you wish to group and plot units by}

\item{showPlots}{Logical indicating if the function should show plots in the Viewer pane immediately after running. Default is TRUE}

\item{...}{additional parameters addressed in inner function}
}
\value{
\code{\link{ENAset}} class object that can be further processed for analysis or plotting, The \code{\link{ENAplot}}s requested.
}
\description{
TBD
}
\details{
TBD
}
\seealso{
\code{\link{ENAdata}}, \code{\link{ena.make.set}}, \code{\link{ena.accumulate.data}}, \code{\link{ena.plot.group}}, \code{\link{ena.plot.network}}, \code{\link{ena.plot}}
}
\keyword{accumulate,}
\keyword{creation,}
\keyword{data,}
\keyword{plotting}
\keyword{set}
