% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_09_fit_linERR_wf.r
\name{f_fit_linERR_wf}
\alias{f_fit_linERR_wf}
\title{fit Excess Relative Risk Model}
\usage{
f_fit_linERR_wf(formula, data, id_name, doses, times, covars, lag,
  exclusion_done = F)
}
\arguments{
\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{data set returned from f_to_model_data}

\item{id_name}{name of variable containing the names of subjects}

\item{doses}{sub data set of grouped doses}

\item{times}{sub data set of times relatives to doses}

\item{covars}{sub data set of the covars that will be involved in the model (adjustments and stratification)}

\item{lag}{latency period}

\item{exclusion_done}{a logical indicating wheather the exclusion is already done or not}
}
\value{
rERR object with the estimation
}
\description{
function that calls the optimization (mle from stats4 package, so use optim) from an event format data set, and return a rERR object with the estimation and summary
}
\examples{
# set the formulas for the models
formula1 <- Surv(AgeAtEntry,age_at_event,outcome) ~ lin(dose_cum) + strata(sex)
formula2 <- Surv(AgeAtEntry,age_at_event,outcome) ~ loglin(factor(country)) + lin(dose_cum) + 
                                                    strata(sex)

  
# fit the models
fit1 <- f_fit_linERR_wf(formula1,data=cohort_wf,id_name="id",doses=cohort_wf[,45:79],
                        times=cohort_wf[,10:44],covars=cohort_wf[,c("sex","country")],
                        lag=2,exclusion_done = FALSE)

fit2 <- f_fit_linERR_wf(formula2,data=cohort_wf,id_name="id",doses=cohort_wf[,45:79],
                        times=cohort_wf[,10:44],covars=cohort_wf[,c("sex","country")],
                        lag=2,exclusion_done = FALSE)

# display a summary
summary(fit1)
summary(fit2)

# confidence intervals
confint(fit1)
confint(fit2) 

# likelihood ratio test between nested and nesting models#' 
f_lrt(fit1,fit2)

}
