% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_15_plot_linERR_ef.r
\name{f_plot_linERR_ef}
\alias{f_plot_linERR_ef}
\title{plot likelihood function from ef}
\usage{
f_plot_linERR_ef(object, formula, data, id_name, dose_name, time_name,
  covars_names, lag, exclusion_done = F)
}
\arguments{
\item{object}{an rERR class object}

\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{data set returned from f_to_model_data}

\item{id_name}{name of variable containing the names of subjects}

\item{dose_name}{name of variable containing the doses at each time}

\item{time_name}{name of the time variable}

\item{covars_names}{a character vector with the names of the variables used as covariates in the fomrula (adjustments and stratification)}

\item{lag}{latency period}

\item{exclusion_done}{a logical indicating wheather the exclusion is already done or not}
}
\value{
rERR object with the estimation
}
\description{
plot the partial log likelihood function in the case of one dimension in the linear part
}
\examples{
# set the formulas for the models
formula1  <- Surv(entry_age,exit_age,outcome) ~ lin(dose_cum) + strata(sex)

# fit the model
fit1 <- f_fit_linERR_ef(formula1,data=cohort_ef,id_name="id",dose_name="dose",
                        time_name="age",covars_names=c("sex"),lag=2,exclusion_done=TRUE)
                        
# plot the partial loglikelihood function
f_plot_linERR_ef(fit1,formula1,data=cohort_ef,id_name="id",dose_name="dose",
                        time_name="age",covars_names=c("sex"),lag=2,exclusion_done=TRUE)
}
