% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmodels.R
\name{fitmodels}
\alias{fitmodels}
\title{Model fitting function for FSA solutions}
\usage{
fitmodels(object, ...)
}
\arguments{
\item{object}{FSA object to construct models on.}

\item{...}{other parameters passed to lm or glm. See help(lm) or help(glm) for other potential arguements.}
}
\value{
list of FSA models that have been fitted.
}
\description{
Model fitting function for FSA solutions
}
\examples{
#use mtcars package see help(mtcars)
data(mtcars)
colnames(mtcars)
fit<-lmFSA(formula="mpg~hp*wt",data=mtcars,fixvar="hp",
     quad=FALSE,m=2,numrs=10,save_solutions=FALSE,cores=1)
fitmodels(fit)
}

