% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLevel2AM.R
\name{getLevel2AM}
\alias{getLevel2AM}
\title{Get GEDI Elevation and Height Metrics (GEDI Level2A)}
\usage{
getLevel2AM(level2a)
}
\arguments{
\item{level2a}{A GEDI Level2A object (output of \code{\link[rGEDI:readLevel2A]{readLevel2A}} function).
An S4 object of class "gedi.level2a".}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}}
containing the elevation and relative heights metrics.
}
\description{
This function extracts Elevation and Relative Height (RH) metrics from GEDI Level2A data.
}
\details{
Characteristics. Flag indicating likely invalid waveform (1=valid, 0=invalid).
\itemize{
\item \emph{beam} Beam identifie
\item \emph{shot_number} Shot number
\item \emph{degrade_flag} Flag indicating degraded state of pointing and/or positioning information
\item \emph{quality_flag} Flag simplifying selection of most useful data
\item \emph{delta_time} Transmit time of the shot since Jan 1 00:00 2018
\item \emph{lat_lowestmode} Latitude of center of lowest mode
\item \emph{lon_lowestmode} Longitude of center of lowest mode
\item \emph{elev_highestreturn} Elevation of highest detected return relative to reference ellipsoid Meters
\item \emph{elev_lowestmode} Elevation of center of lowest mode relative to reference ellipsoid
\item \emph{rh} Relative height metrics at 1\% interval
}
}
\examples{

# Specifying the path to GEDI level2A data (zip file)
outdir = tempdir()
level2A_fp_zip <- system.file("extdata",
                  "GEDI02_A_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Apath <- unzip(level2A_fp_zip,exdir = outdir)

# Reading GEDI level2A data (h5 file)
level2a<-readLevel2A(level2Apath=level2Apath)

# Extracting GEDI Elevation and Height Metrics
level2AM<-getLevel2AM(level2a)
head(level2AM)

close(level2a)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_av001/
}
