% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estKIN.R
\name{estKIN}
\alias{estKIN}
\title{Estimate Kernel Isotope Niche}
\usage{
estKIN(data, x, y, group, levels = c(50, 75, 95), scaler = 10,
  smallSamp = FALSE)
}
\arguments{
\item{data}{data.frame object containing columns of isotopic values and grouping variables}

\item{x}{character giving the column name of the x coordinates}

\item{y}{character giving the column name of the y coordinates}

\item{group}{character giving the column name of the grouping variable (i.e. species)}

\item{levels}{Numeric vector of desired percent levels (e.g. c(10, 50, 90). Should not be less than 1 or greater than 99)}

\item{scaler}{numeric value to expand the min/max x and y values. This assists with error given smaller sample sizes. Default value = 10}

\item{smallSamp}{logical value indicating whether to override minimum number of samples. Currently 10 samples are required.}
}
\value{
A class rKIN object containing a list of SpatialPolygonsDataFrame, each list item representing the grouping variable.
}
\description{
Calculates the 2D kernel for isotopic values at multiple confidence levels. Returns a list of
SpatialPolygonsDataFrame, each list item representing the grouping variable (i.e. species).
}
\examples{
library(rKIN)
data("rodents")
#estimate niche overlap between 2 species using kernel UD
test.kin<- estKIN(data=rodents, x="Ave_C", y="Ave_N", group="Species",
                 levels=c(50, 75, 95), scaler=2)
#determine polygon overlap for all polygons
plotKIN(test.kin, scaler=2, title="Kernel Estimates", xlab="Ave_C", ylab="Ave_N")
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}

