% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm.R
\name{pm_infer}
\alias{pm_infer}
\title{Call the g function}
\usage{
pm_infer(pm, u = NULL)
}
\arguments{
\item{pm}{is the \code{pm} object.}

\item{u}{is the new \code{pm} input. By default is NULL.}
}
\value{
the \code{pm} obtained after calling \code{g}.
}
\description{
It call the \code{g} function in order to make the inference,
 i.e.,  map inputs \code{u} to output \code{y}.
}
\examples{

cp_depth <- cp("cp_depth", c("far",
                           "bit far",
                           "good",
                           "close",
                           "very close"))

g_depth <- function(u,y){
   y$w <- degree_mf(fuzzy_partitions(triangle_mf(450,450,550),
                                              triangle_mf( 450,550,600),
                                              trapezoid_mf(550,600,800, 1000),
                                              triangle_mf( 800,1000,1300),
                                              trapezoid_mf( 1000,1300,1500,1500)),u)
 y
}

pm_depth  <- pm(y=cp_depth, g=g_depth)
pm_depth   <- pm_infer(pm_depth, 650)

}
\seealso{
\code{\link{cp}}
}

