% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espa_status.R
\name{espa_status}
\alias{espa_status}
\title{Get Landsat Order Status and Download URL}
\usage{
espa_status(order_id = NULL, min_date = NULL, max_date = NULL,
  getSize = FALSE, host = "https://espa.cr.usgs.gov/api/v1/",
  username = NULL, password = NULL)
}
\arguments{
\item{order_id}{vector of order ids for which status and download url is needed}

\item{min_date}{if order_id is NULL, define the starting date from which order ids need to be fetched}

\item{max_date}{if order_id is NULL, define the ending date till which order ids need to be fetched}

\item{getSize}{logical. if the status is completed for the entire order, then should the file size be calculated. (Output size in Bytes)}

\item{host}{the api call host. Default set to espa v1 web api}

\item{username}{default NULL, which fetches the username from the global environment. If defined otherwise, will run the api with the provided details}

\item{password}{default NULL, which fetches the password from the global environment. If defined otherwise, will run the api with the provided details}
}
\value{
a list
\item{order_details}{a dataframe with order status and download links}
\item{wrong_order_id}{vector of order_ids for which the API failed}
}
\description{
For a successful order placed, get the status of each of the product ID requested in that order id. Once the order is complete, also get the corresponding URLs for the product IDs.
}
\details{
if order_id, min_date, max_date are NULL, then will run on all the order ids available till date
}
\examples{
\dontrun{
# input the credentials, if not defined earlier
 espa_creds("your_espaname", "secret_password")

# getting all the orders' status
 result = espa_status()
 # getting the dataframe from the list
 result = result$order_details}
}
