% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_ccf.R
\name{MEAccf}
\alias{MEAccf}
\title{Moving-windows lagged cross-correlation routine for \code{MEA} and \code{MEAlist} objects}
\usage{
MEAccf(mea, lagSec, winSec, incSec, r2Z = T, ABS = T)
}
\arguments{
\item{mea}{an object of class \code{MEA} or \code{MEAlist} (see function \code{\link{readMEA}})}

\item{lagSec}{an integer specifying the maximum number of lags (in seconds) for which the time-series will be shifted forwards and backwards.}

\item{winSec}{an integer specifying the cross-correlation window size (in seconds).}

\item{incSec}{an integer specifying the step size (in seconds) between successive windows. Values lower than \code{winSec} result in overlapping windows.}

\item{r2Z}{logical. The default value TRUE applies Fisher's r to Z transformation to all computed correlations.}

\item{ABS}{logical. The default value TRUE transforms the (Fisher's Z-transformed) correlations to absolute values.}
}
\value{
The function returns a copy of the \code{mea} object which includes a cross-correlation table
}
\description{
This function analyzes a bivariate MEA signal represented by two time-series (subject 1 "s1", subject 2 "s2") resulting from a dyadic interaction.
MEAccf performs windowed cross-correlations with specified increments. The cross-correlation analysis is repeated for each
lag step, with discrete increments of 1 second in both directions.
}
\details{
The choice of \code{lagSec} depends on the type of synchronization expected from the specific interaction. In the literature, lags of ±5 seconds have been reported by multiple authors.
Function \code{\link{MEAlagplot}} can be used for visual inspection of the appropriateness of the chosen lag.

 The choice of \code{winSec} represents the temporal resolution of the analysis.
 The combination of \code{incSec} and \code{winSec} settings has a big impact on the results. These parameters should be chosen carefully, guided by theoretical and empirical considerations.

 If \code{r2Z} is TRUE, values of Fisher's Z are constrained to an upper bound of 10.

Using absolute values (\code{ABS}) treats positive and negative cross-correlations as equal. The underlying assumption is that both simultaneous movement (positive correlation) and when
one subject accelerates and the other decelerates (negative correlation), are both signs of interrelatedness and should thus contribute equally to overall synchrony.
}
\examples{
## read a single file
path_normal <- system.file("extdata/normal/200_01.txt", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist", skip=1,
                     idOrder = c("id","session"), idSep="_")

## perform ccf analysis
mea_ccf = MEAccf(mea_normal, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)
summary(mea_ccf)

#visualize the analysis results for the first file
MEAheatmap(mea_ccf[[1]])

}
